set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9013377';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      23,
      NULL,
      NULL,
      107,
      2,
      1,
      NULL,
      '110413',
      4,
      NULL,
      34.754896,
      40.893760,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.497887,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.052380,
      NULL,
      0,
      0,
      1.459031,
      NULL,
      1.120434,
      3.642182,
      0,
      0.483023,
      0.767804,
      NULL,
      NULL,
      5.991448,
      0,
      1,
      NULL,
      0.761917,
      0.810307,
      NULL,
      NULL,
      1.556391,
      NULL,
      NULL,
      NULL,
      0.354749,
      0,
      1.904281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4.239215,
      1,
      3,
      NULL,
      0.769099,
      0.667148,
      0,
      0,
      0.376719,
      1.913087,
      1,
      1.379834,
      1,
      NULL,
      1.598953,
      1.717509,
      0.149037,
      NULL,
      1.400867,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.124764,
      1.578672,
      NULL,
      NULL,
      NULL,
      NULL,
      0.778385,
      1,
      1.411482,
      0,
      1.927468,
      NULL,
      0,
      1.788321,
      5.119943,
      7,
      NULL,
      7.817224,
      5.242412,
      3.495531,
      7.838445,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.337072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.488809,
      0.933975,
      1,
      0,
      1,
      0.621548,
      1.177068,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.121137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.569561,
      0.124612,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      2,
      1,
      1.363184,
      NULL,
      NULL,
      NULL,
      1.201010,
      5.149385,
      1.489148,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.272745,
      1,
      NULL,
      0.216817,
      NULL,
      0.444308,
      NULL,
      3,
      0.100294,
      NULL,
      1.505986,
      0,
      0,
      0.769573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.346211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.004945,
      '',
      '',
      '',
      0,
      '3330',
      '1320',
      '',
      NULL,
      1,
      0,
      2,
      1.870494,
      3,
      2,
      0.638763,
      2.620479);
commit;
end;
/


