set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9013377';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-6-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1201',
      '40400422',
      NULL,
      NULL,
      '2331442',
      NULL,
      0,
      2,
      1,
      NULL,
      4.421190,
      NULL,
      314,
      2,
      0.220917,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      1.287901,
      NULL,
      3.962841,
      2,
      1.070670,
      0.897077,
      0,
      NULL,
      7.367317,
      0.682262,
      1,
      1.180997,
      NULL,
      1,
      1,
      0,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.181801,
      1.587127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.187911,
      0.997842,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      1,
      NULL,
      0.146276,
      0.475978,
      1.566326,
      1,
      1,
      NULL,
      NULL,
      0,
      0.526978,
      NULL,
      1,
      0.343989,
      NULL,
      1.962892,
      0.665391,
      0,
      3.144108,
      NULL,
      1.952093,
      1.563482,
      NULL,
      NULL,
      1.447694,
      1.904767,
      0.407930,
      1.639878,
      1,
      1.495317,
      0,
      NULL,
      NULL,
      6.067089,
      0,
      0.908591,
      NULL,
      4.007535,
      6.827433,
      NULL,
      2,
      9.112255,
      3.188200,
      1,
      NULL,
      NULL,
      4,
      1.292095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1.240648,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.040875,
      NULL,
      NULL,
      2,
      1.322076,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.433136,
      2.872906,
      0.525575,
      NULL,
      NULL,
      NULL,
      NULL,
      1.581567,
      0.048802,
      2.410653,
      5.463586,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3.887705,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      NULL,
      1,
      3.486443,
      1.726612,
      1,
      NULL,
      1.207999,
      NULL,
      NULL,
      0,
      0.410766,
      0.654018,
      0,
      1,
      0,
      1.801984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '40214',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '0420',
      '0042',
      NULL,
      2.428414,
      3,
      1,
      3.662488,
      3.587186,
      1.334003,
      0.863502,
      2.321750,
      NULL);
commit;
end;
/


