set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0142885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0023',
      '13324414',
      10.905598,
      65.726265,
      '2101112',
      5.466477,
      NULL,
      3,
      3,
      '400401',
      3.599971,
      ' 7-21-1977',
      55,
      5.071384,
      1.615199,
      NULL,
      NULL,
      0,
      1.609697,
      1.349161,
      1,
      3.152018,
      NULL,
      1,
      0.166015,
      1.882074,
      NULL,
      0.168415,
      1.084786,
      NULL,
      0,
      0.238424,
      3.723548,
      0.923201,
      1.952533,
      0,
      1.392346,
      0.163123,
      2.020565,
      1,
      1.389204,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.013880,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.570147,
      NULL,
      1,
      NULL,
      0,
      1,
      1.795371,
      1,
      NULL,
      NULL,
      1.000688,
      NULL,
      NULL,
      1.485926,
      1.009744,
      NULL,
      2.908257,
      2,
      1,
      NULL,
      0.281426,
      1.051120,
      0.433717,
      NULL,
      1,
      0.830930,
      0,
      1,
      0.973741,
      1.154665,
      0,
      0,
      NULL,
      1,
      3,
      1.907253,
      1.880226,
      2,
      NULL,
      0,
      1,
      2,
      1,
      1,
      NULL,
      2.852945,
      NULL,
      1.877445,
      0,
      0.264089,
      11.076099,
      NULL,
      NULL,
      NULL,
      11,
      5,
      4.010353,
      7.755355,
      5,
      5,
      1,
      NULL,
      0.380939,
      1,
      0.576263,
      0.645581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.676602,
      NULL,
      0.325128,
      1.273526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.791712,
      3.953450,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      2,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1.634655,
      1,
      0.452943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      3.661908,
      2.679988,
      3,
      0,
      NULL,
      0,
      1.564081,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      1.319246,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.832496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '21122',
      '',
      '',
      1.558938,
      '02414',
      '',
      '',
      NULL,
      '',
      '',
      '',
      3.837381,
      3.242657,
      3,
      NULL,
      3.132856,
      2,
      4,
      1,
      2.101599);
commit;
end;
/


