set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9535111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-7-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '303',
      NULL,
      5,
      5.355491,
      '0224324',
      NULL,
      1,
      NULL,
      1,
      NULL,
      3,
      ' 8-17-1980',
      42,
      7,
      1.197775,
      NULL,
      0,
      1,
      NULL,
      1.143587,
      0.493727,
      2,
      1.933592,
      NULL,
      1.384355,
      0,
      7,
      NULL,
      0.956189,
      4.780260,
      1.970714,
      0,
      3.450405,
      1.900752,
      1,
      2,
      1.906408,
      3.062317,
      3.645974,
      0,
      NULL,
      NULL,
      3.082737,
      NULL,
      NULL,
      NULL,
      1.755500,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.783866,
      NULL,
      NULL,
      1.632650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.819273,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.292458,
      1.344077,
      0.496598,
      1,
      NULL,
      1,
      NULL,
      0.436895,
      1.592956,
      1.371231,
      1,
      1.143042,
      1,
      NULL,
      1.386746,
      NULL,
      1,
      0.400839,
      0,
      NULL,
      4,
      NULL,
      1.549769,
      1,
      4.983160,
      4,
      1.215420,
      0.143037,
      3.803876,
      1.904108,
      0.725569,
      6.447095,
      5.683798,
      NULL,
      9.055611,
      9,
      NULL,
      2.867224,
      6.530051,
      NULL,
      0.372767,
      0,
      1,
      1.268173,
      0,
      9.419422,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.464982,
      1.405152,
      0,
      NULL,
      1.308549,
      0.450317,
      0,
      0.443016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1.339856,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.212764,
      1,
      0.116202,
      NULL,
      NULL,
      NULL,
      NULL,
      2.970095,
      7,
      4.837277,
      1.100772,
      0,
      3.384108,
      1,
      NULL,
      NULL,
      0.612587,
      0.129993,
      1.511331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2.123091,
      1.002948,
      3,
      NULL,
      0.812272,
      0.277158,
      1,
      0.736696,
      1,
      NULL,
      1.640021,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.582167,
      NULL,
      '44410',
      NULL,
      1.847307,
      '',
      '',
      '',
      1.018601,
      '',
      '',
      '',
      3.382641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


