set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9535111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-9-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '223',
      NULL,
      NULL,
      NULL,
      '2102421',
      48.120413,
      4,
      1,
      NULL,
      '330100',
      0,
      '10-11-1977',
      NULL,
      18,
      NULL,
      NULL,
      1,
      1.584404,
      1,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      0.385570,
      1,
      NULL,
      NULL,
      0,
      3.704582,
      1,
      1.286283,
      1,
      0.200565,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.244259,
      0.978698,
      0.791269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.225949,
      1.801063,
      1.807039,
      0.565874,
      1,
      0.606042,
      NULL,
      0.264759,
      0.058333,
      1,
      0,
      1,
      NULL,
      0,
      0.571216,
      0.008200,
      NULL,
      0.208234,
      NULL,
      NULL,
      1.751006,
      0.519687,
      1,
      0.237724,
      1.375583,
      0.393209,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.827735,
      0.854920,
      0,
      1.952525,
      2.162850,
      4.668680,
      0,
      NULL,
      1.167792,
      0.758240,
      NULL,
      1.801974,
      NULL,
      1,
      NULL,
      1.494566,
      NULL,
      NULL,
      0,
      1.297660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.691551,
      1,
      0,
      0,
      0.963204,
      NULL,
      0,
      0.284660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.125912,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.331298,
      NULL,
      0.813660,
      1.984546,
      0.757236,
      0,
      0.123682,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.526219,
      3.520598,
      1.510230,
      NULL,
      1.476033,
      NULL,
      NULL,
      NULL,
      1.809248,
      2.170573,
      1.033583,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.099658,
      1.761698,
      NULL,
      3,
      3,
      1.914029,
      2,
      0,
      1.848440,
      NULL,
      NULL,
      1.556385,
      0,
      0,
      1,
      1.057435,
      1,
      0,
      1.011079,
      1.015920,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '34342',
      '',
      0,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      2,
      0,
      2,
      2.713444,
      3,
      NULL,
      2);
commit;
end;
/


