set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9535111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '104',
      '21143113',
      NULL,
      2,
      '1201343',
      0.445992,
      5,
      1,
      3,
      '224442',
      NULL,
      NULL,
      NULL,
      43,
      NULL,
      NULL,
      1.218918,
      1.224119,
      NULL,
      0.990729,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.242928,
      NULL,
      1,
      2,
      0.489285,
      0.636344,
      1,
      1.255136,
      1,
      1.928205,
      1.320789,
      0.102304,
      0.686626,
      0,
      1,
      0.064722,
      0,
      1,
      1.578343,
      NULL,
      NULL,
      1.165459,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.452563,
      NULL,
      0,
      0.466163,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.100036,
      NULL,
      1,
      NULL,
      0,
      1.257552,
      0.534859,
      1,
      0,
      1,
      1.382943,
      1,
      0.487047,
      NULL,
      1.647988,
      0.086783,
      0,
      1.039185,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.731829,
      1.706061,
      0,
      1.740491,
      NULL,
      NULL,
      NULL,
      NULL,
      0.205129,
      4,
      2.808289,
      1.974959,
      0,
      9.597822,
      9,
      4.092703,
      9.748042,
      9,
      4,
      6,
      2.284456,
      1,
      1.911960,
      0,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.217898,
      0,
      0.071370,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      3,
      1.025804,
      3,
      NULL,
      3,
      0.568712,
      0,
      NULL,
      9.762961,
      0,
      1,
      0,
      0,
      3,
      1.676933,
      2,
      3.457375,
      0.465762,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3.660736,
      1.591144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3.158519,
      0,
      NULL,
      1.365334,
      0,
      3,
      1.292012,
      0.500104,
      1.695263,
      1,
      0.875235,
      0.814060,
      0.283065,
      0,
      0.916881,
      1,
      1,
      NULL,
      0,
      0.759427,
      0,
      0.984259,
      2.490885,
      3.976180,
      3.022621,
      0.367334,
      NULL,
      NULL,
      1,
      1,
      1.655846,
      NULL,
      NULL,
      0,
      1.216341,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.436349,
      '40330',
      NULL,
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      0.381826,
      2.701128,
      0.524434,
      3,
      0.069254,
      1.440815,
      2,
      3);
commit;
end;
/


