set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9535111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '012',
      '10414322',
      1,
      27.178443,
      NULL,
      146,
      4,
      3.529479,
      0,
      '341201',
      1,
      '10-25-2003',
      1,
      57.498407,
      1,
      NULL,
      NULL,
      NULL,
      1.795236,
      0,
      1,
      1.985737,
      0.839796,
      0.815870,
      NULL,
      1.065935,
      NULL,
      1.636227,
      0,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      1,
      1,
      0,
      1.319829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.481756,
      NULL,
      1,
      0,
      0.586276,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.177563,
      1.501386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.094275,
      NULL,
      0.135223,
      0.342504,
      0,
      NULL,
      0.249411,
      0.254740,
      NULL,
      0,
      1.257942,
      1.677252,
      1.686455,
      0.965431,
      1,
      0.524655,
      1.069844,
      0,
      NULL,
      1,
      0.959748,
      NULL,
      0,
      NULL,
      1.052334,
      7.322587,
      0.949074,
      9,
      3.565002,
      NULL,
      NULL,
      5,
      3.278693,
      8.529170,
      NULL,
      0,
      4.394939,
      6.262033,
      2.437787,
      2,
      3,
      NULL,
      NULL,
      10.600202,
      4,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      0.117622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.158413,
      0.819523,
      1.206567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.140335,
      NULL,
      2.653273,
      NULL,
      0,
      1.836363,
      0,
      0.321920,
      1,
      0.292698,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.980868,
      NULL,
      7,
      NULL,
      9.666069,
      2,
      7.752225,
      3.878839,
      NULL,
      2,
      0,
      3.232458,
      3,
      1,
      1,
      6.761450,
      2.775990,
      0.082823,
      NULL,
      0.913462,
      1.018591,
      2.404926,
      NULL,
      NULL,
      3.495203,
      0.996378,
      3.409646,
      1.329709,
      NULL,
      3.146253,
      1,
      NULL,
      1,
      NULL,
      1.741991,
      1.614584,
      1,
      0.542386,
      0,
      1.726273,
      0,
      NULL,
      0,
      2.809134,
      0.269114,
      0,
      0,
      1.446962,
      0.915638,
      1.821275,
      0.945789,
      NULL,
      0.361466,
      0,
      0.872030,
      1,
      0,
      1,
      0.225402,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.605592,
      '34301',
      '24443',
      '',
      0.829795,
      NULL,
      '',
      '',
      1.355479,
      NULL,
      '',
      '',
      NULL,
      0.945925,
      3,
      0.874995,
      0,
      2.500689,
      3,
      3.442206,
      2);
commit;
end;
/


