set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9535111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '30113301',
      73,
      53,
      '1234323',
      25,
      NULL,
      0.347689,
      3,
      NULL,
      NULL,
      ' 1- 4-1992',
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      2.399768,
      NULL,
      NULL,
      0.736651,
      1,
      0.649471,
      0.029635,
      1.451891,
      NULL,
      NULL,
      0.476168,
      0,
      0.732825,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.518070,
      0,
      3.161637,
      0,
      0.671845,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.694246,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.992547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.165957,
      0.033046,
      0.839613,
      1,
      NULL,
      1.390249,
      1,
      NULL,
      0,
      1,
      0.028815,
      0.252012,
      1.127157,
      0,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      1.691963,
      2.883919,
      1.188078,
      1,
      1,
      1,
      4,
      3.660099,
      NULL,
      NULL,
      NULL,
      NULL,
      2.480493,
      3,
      NULL,
      1.483908,
      3.319277,
      NULL,
      3.569639,
      0,
      3,
      5,
      1.620491,
      0,
      3,
      2,
      0.592243,
      2.634908,
      NULL,
      NULL,
      NULL,
      NULL,
      0.537079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.822980,
      0,
      1,
      0,
      NULL,
      0.015555,
      1.623496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.430194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.074047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      6,
      0.736568,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.299567,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0,
      3,
      2.454118,
      1.418842,
      0,
      1.362452,
      1.596755,
      0.641545,
      0.162462,
      1,
      1.586533,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.861034,
      '31023',
      '20404',
      '',
      0.339738,
      '',
      '',
      '',
      1.153070,
      NULL,
      '',
      NULL,
      3.018822,
      2.609482,
      1,
      3,
      NULL,
      NULL,
      3.570390,
      0,
      2);
commit;
end;
/


