set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9535111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4400',
      '32214403',
      42.362514,
      38,
      '3130402',
      NULL,
      5,
      1,
      2,
      '411022',
      NULL,
      ' 2- 0-1992',
      0,
      54,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.678245,
      NULL,
      0,
      3.920008,
      1,
      0.465999,
      2,
      0.250534,
      1.966557,
      0,
      1,
      1.804419,
      0.890280,
      1,
      0.739604,
      0,
      0.434763,
      NULL,
      4.468361,
      0,
      1.485026,
      NULL,
      1.274742,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      0.393264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.242056,
      0.177171,
      0.381986,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.257046,
      0,
      1.356648,
      1.159407,
      NULL,
      0,
      1,
      0.318252,
      0.792864,
      1,
      0.012821,
      1.064943,
      1,
      0,
      NULL,
      0.273373,
      1,
      1.119751,
      NULL,
      0,
      5.771828,
      0.713582,
      0,
      NULL,
      1,
      0.037599,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.050139,
      NULL,
      0,
      0.703513,
      3,
      6,
      5,
      NULL,
      4,
      0,
      NULL,
      NULL,
      7.782829,
      1.247568,
      1,
      1,
      1.568321,
      NULL,
      NULL,
      7.198409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.688991,
      1.837767,
      1,
      1,
      1.143415,
      0.826227,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.465586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.277650,
      NULL,
      NULL,
      1.019241,
      4.838506,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      3,
      NULL,
      2.716786,
      1,
      0.789835,
      NULL,
      NULL,
      NULL,
      0.876473,
      1,
      1.374585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.440417,
      0,
      0,
      1.644108,
      NULL,
      3,
      0.237887,
      NULL,
      NULL,
      0,
      1,
      1.040638,
      0,
      NULL,
      1.612453,
      1.347792,
      1,
      1,
      0.608476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.212560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '24031',
      '',
      0,
      '',
      '',
      '',
      1.299041,
      '',
      '',
      '',
      2,
      1,
      1.192829,
      3,
      0,
      2.145079,
      NULL,
      NULL,
      3.649776);
commit;
end;
/


