set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9535111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-9-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '11200304',
      38,
      NULL,
      '2424304',
      NULL,
      1,
      NULL,
      1,
      '104421',
      2,
      ' 3-12-1984',
      NULL,
      35,
      0,
      NULL,
      1,
      0.540034,
      0,
      0,
      0.315886,
      1,
      3.159066,
      1,
      1,
      0,
      6.068605,
      1,
      4.563559,
      0,
      0,
      NULL,
      NULL,
      1,
      4,
      1.025282,
      NULL,
      0.692638,
      NULL,
      NULL,
      2,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.044016,
      1,
      2,
      0,
      1,
      NULL,
      1.642487,
      1,
      3.246932,
      NULL,
      1.491356,
      3,
      0.737401,
      1.446674,
      1,
      0,
      3,
      NULL,
      1.312766,
      1,
      1,
      4,
      1,
      NULL,
      3.906951,
      1,
      NULL,
      NULL,
      0.474930,
      NULL,
      NULL,
      0.139234,
      1.773659,
      NULL,
      0,
      1.688826,
      NULL,
      1.757330,
      0,
      NULL,
      NULL,
      NULL,
      1.998016,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      1.438287,
      NULL,
      0,
      4,
      0,
      0,
      0.163018,
      1.770155,
      3,
      NULL,
      6,
      0.233093,
      NULL,
      NULL,
      2,
      NULL,
      4.271990,
      1,
      0,
      9.533950,
      NULL,
      NULL,
      8.552285,
      1,
      2.388167,
      5,
      9,
      1,
      1,
      1,
      NULL,
      1.112717,
      NULL,
      0.561805,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.768021,
      2,
      1,
      1,
      NULL,
      1.102118,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      8.347606,
      3,
      3.225687,
      0.884987,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.237963,
      1.394686,
      NULL,
      NULL,
      NULL,
      1,
      0,
      9.338632,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.478651,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.289174,
      0.005994,
      3,
      NULL,
      1.557309,
      1,
      NULL,
      NULL,
      1,
      2.295339,
      NULL,
      0.240849,
      1.126656,
      1.487370,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.005548,
      '22014',
      NULL,
      '',
      1.021592,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      0.821978,
      1.657879,
      NULL,
      3,
      1,
      0,
      3.876631);
commit;
end;
/


