set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7403992';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-5-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '141',
      '42',
      52,
      28,
      '0420310',
      77,
      NULL,
      0,
      NULL,
      '340220',
      1,
      '10- 8-1995',
      62.264548,
      53,
      0,
      NULL,
      1,
      1,
      2,
      NULL,
      1,
      1,
      0,
      3.033966,
      NULL,
      0,
      0.018456,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.310980,
      0.846330,
      1,
      5.579695,
      0,
      0,
      0,
      0,
      1.082783,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.414118,
      0,
      1.005518,
      3.077749,
      0,
      1.967743,
      NULL,
      2,
      NULL,
      1,
      2,
      0.441268,
      1.960503,
      2.661063,
      1,
      1.922319,
      3.383434,
      0.079543,
      1.200679,
      0.028172,
      1,
      0.910818,
      5.757496,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.956706,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.917585,
      1.570934,
      6.059683,
      1.069177,
      4,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.306316,
      0,
      1,
      NULL,
      NULL,
      2.901943,
      5,
      5.810196,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      0,
      NULL,
      2.830296,
      NULL,
      6,
      4.487685,
      NULL,
      9,
      NULL,
      4.837075,
      2,
      2.086198,
      NULL,
      4.193887,
      NULL,
      NULL,
      NULL,
      9.223904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.796127,
      1,
      NULL,
      NULL,
      1.106965,
      1.455519,
      0.798461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.572382,
      NULL,
      NULL,
      NULL,
      NULL,
      4.208054,
      1.551777,
      1,
      0,
      0,
      2.639463,
      NULL,
      0.039240,
      1.302786,
      3,
      1.988240,
      2.563544,
      NULL,
      1.227477,
      3.731508,
      NULL,
      NULL,
      NULL,
      1.698142,
      NULL,
      NULL,
      NULL,
      1.142567,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.762804,
      2,
      NULL,
      0.919180,
      1.694563,
      1.410947,
      1.783820,
      1.507254,
      NULL,
      0.082568,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.623648,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '01214',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0,
      '',
      NULL,
      '',
      4,
      5,
      2,
      3.697779,
      1,
      2.731463,
      2,
      3,
      2);
commit;
end;
/


