set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7403992';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-10-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '322',
      '40114121',
      22,
      40.003306,
      '0133234',
      102,
      3,
      2.332826,
      3,
      NULL,
      5,
      NULL,
      38,
      5.699369,
      1.297000,
      NULL,
      1.390825,
      0.843296,
      1,
      0,
      1.916491,
      0,
      NULL,
      2.670699,
      1,
      1.794903,
      0,
      1.908748,
      0,
      3,
      0.223007,
      1,
      0.870337,
      1.347133,
      0,
      NULL,
      NULL,
      0,
      5,
      1,
      0.050634,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.235933,
      1.129376,
      3,
      NULL,
      0,
      2,
      0,
      3.383184,
      NULL,
      2.189378,
      0.389479,
      0,
      1,
      1.961464,
      NULL,
      2,
      2,
      1,
      0,
      1.095328,
      1,
      0,
      1,
      NULL,
      3.841438,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.469360,
      1.879445,
      0.887193,
      0.418740,
      3.090402,
      1,
      1.616728,
      1,
      3,
      3,
      0,
      0.264283,
      1,
      3.227578,
      1.191205,
      1.572627,
      1,
      1,
      1.395359,
      NULL,
      0,
      1,
      4.970627,
      NULL,
      NULL,
      1.567002,
      0,
      3.943893,
      NULL,
      NULL,
      NULL,
      NULL,
      5.095312,
      5.042096,
      0.792162,
      0,
      4.164592,
      5,
      7.921757,
      4,
      4.093052,
      7.363261,
      0,
      7.378208,
      7,
      1.998960,
      NULL,
      5.814703,
      1.080350,
      NULL,
      NULL,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.635719,
      0,
      2,
      0,
      1.875667,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.022474,
      NULL,
      NULL,
      NULL,
      NULL,
      0.803499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.210931,
      2.680582,
      NULL,
      0,
      1,
      0,
      NULL,
      5,
      2.541410,
      0.582679,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      0.602625,
      2,
      1,
      2.936933,
      0,
      2.717890,
      2.642520,
      0.424437,
      NULL,
      0,
      1.040837,
      0.112404,
      1,
      1,
      0,
      1.585562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.255454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '20022',
      '',
      '',
      0.139639,
      '',
      '',
      '',
      1.759274,
      NULL,
      '',
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      3,
      0.922767,
      NULL,
      1.759942);
commit;
end;
/


