set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7403992';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '022',
      NULL,
      28.829413,
      19,
      '2002321',
      84.501659,
      5,
      3.237345,
      1,
      '440114',
      3,
      ' 7-19-1978',
      58,
      38,
      1.375760,
      NULL,
      1.594503,
      NULL,
      2,
      0.941071,
      0.354180,
      0,
      NULL,
      0.932272,
      0,
      NULL,
      3.037953,
      1.978684,
      1.800361,
      2.010556,
      1,
      1.699913,
      3.208682,
      0,
      NULL,
      0,
      1.542947,
      0.693412,
      2,
      NULL,
      0,
      1.523721,
      0.773935,
      0.717609,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0.043427,
      3.362247,
      0,
      1,
      0,
      2.633556,
      3.986932,
      1.388909,
      0,
      0,
      0,
      NULL,
      0.218702,
      0.726018,
      1,
      1,
      0.506177,
      0.719124,
      0,
      0.745173,
      5.123500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.868008,
      1.823477,
      NULL,
      NULL,
      2.490601,
      1.586884,
      0.489483,
      4.401800,
      1.550106,
      1,
      1.927670,
      2,
      1.664796,
      0,
      0.806321,
      1.600245,
      1,
      NULL,
      0,
      0,
      2.614367,
      1.848797,
      NULL,
      NULL,
      0.488104,
      3.891616,
      NULL,
      NULL,
      NULL,
      NULL,
      0.490642,
      3,
      1,
      4.980877,
      3,
      2,
      4,
      0,
      9.310705,
      6,
      3,
      4.082834,
      1,
      1,
      0.390883,
      0,
      0.268687,
      NULL,
      NULL,
      NULL,
      0.936339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.662044,
      NULL,
      NULL,
      0.132848,
      NULL,
      1,
      0.558304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.642000,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.950702,
      1,
      3,
      0,
      1.438623,
      NULL,
      1.440707,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.700849,
      1,
      0.377986,
      3,
      NULL,
      1,
      0.839751,
      NULL,
      3.223670,
      NULL,
      1,
      1.534907,
      NULL,
      1,
      1.394821,
      NULL,
      0.979945,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      '',
      '',
      0.220741,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      5,
      NULL,
      1,
      3.747174,
      3.966752,
      2.415751,
      1,
      1,
      1);
commit;
end;
/


