set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7403992';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '323',
      '33423440',
      30,
      NULL,
      '4133301',
      105,
      NULL,
      1.479901,
      2,
      '431232',
      5.746724,
      ' 7-14-1985',
      41.263973,
      44.504486,
      NULL,
      NULL,
      0,
      1,
      3.073066,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.888902,
      0.119670,
      1,
      1,
      NULL,
      1,
      0.234800,
      0.688844,
      NULL,
      0.578432,
      0,
      0,
      1,
      1.190079,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      1.467061,
      3.878227,
      NULL,
      1,
      3,
      2.623169,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3.940011,
      NULL,
      0,
      0.131432,
      0.167487,
      NULL,
      1,
      0,
      1,
      1.126353,
      0,
      0,
      1.952563,
      0.725778,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.328743,
      0,
      1,
      1.442218,
      1.772686,
      2,
      0,
      NULL,
      3,
      0,
      0.584760,
      1,
      3.809592,
      0.377183,
      1.511297,
      0,
      1.719790,
      1.108583,
      NULL,
      1,
      0,
      0.247159,
      1,
      0.396355,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.992180,
      4.618591,
      0,
      7,
      6.826971,
      9.557822,
      0.935511,
      NULL,
      7.488422,
      7.020174,
      2.440425,
      1.715457,
      2.212170,
      2.589774,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.175333,
      1,
      1,
      1.306064,
      1.694709,
      NULL,
      0.493297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.404113,
      0,
      NULL,
      NULL,
      1.874829,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.196341,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.339717,
      NULL,
      1,
      3,
      2.173484,
      1,
      NULL,
      3,
      0,
      2,
      NULL,
      1,
      0.117140,
      0,
      1,
      NULL,
      NULL,
      0.116183,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.610010,
      '43000',
      NULL,
      '',
      0,
      NULL,
      NULL,
      '',
      0.320704,
      NULL,
      '',
      NULL,
      0.712815,
      4.968704,
      3,
      0,
      5.816888,
      3.346614,
      1,
      2.221346,
      2.506708);
commit;
end;
/


