set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7403992';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-4-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '143',
      '23240302',
      28,
      NULL,
      '3043234',
      39,
      NULL,
      0,
      0,
      '242402',
      1,
      ' 8-21-1981',
      52,
      26,
      1,
      NULL,
      1.334967,
      NULL,
      NULL,
      1,
      1.852324,
      0.489768,
      1,
      0,
      0.086801,
      0,
      4.813426,
      NULL,
      NULL,
      1,
      0.384989,
      1,
      3,
      1.185587,
      0.426027,
      0,
      0,
      NULL,
      1.687716,
      NULL,
      NULL,
      NULL,
      0.430821,
      1,
      NULL,
      NULL,
      0.867506,
      NULL,
      NULL,
      3,
      0.331838,
      0.319875,
      1,
      1,
      0.062663,
      NULL,
      1.458406,
      1.533586,
      1.028644,
      NULL,
      2,
      NULL,
      1,
      1,
      0,
      2.856069,
      1.756570,
      2.881372,
      0,
      1,
      1,
      4,
      0,
      1,
      NULL,
      1.247719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.244890,
      1,
      1,
      0.973403,
      1,
      0.641937,
      3.329576,
      1,
      NULL,
      1,
      0,
      0.505977,
      0.677655,
      NULL,
      1.301936,
      NULL,
      NULL,
      0.722650,
      0.511523,
      NULL,
      0.723751,
      0,
      NULL,
      NULL,
      1,
      1.627334,
      0.368646,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.458541,
      0.851602,
      0.915974,
      2.261348,
      NULL,
      6,
      NULL,
      1.060363,
      4.201733,
      6,
      3,
      1,
      5.483130,
      1,
      0,
      0.895939,
      NULL,
      NULL,
      NULL,
      NULL,
      0.035776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.236615,
      0,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.985162,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.148641,
      0.734174,
      0.098865,
      0,
      0,
      0,
      0.100136,
      NULL,
      NULL,
      NULL,
      0,
      1.954662,
      1.530903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.304811,
      0.219258,
      3,
      NULL,
      1,
      1.907195,
      NULL,
      1,
      1.323576,
      0.843326,
      1,
      1.827615,
      1,
      1,
      NULL,
      1,
      0,
      1.821777,
      1.742848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.720639,
      '20104',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.550244,
      '',
      NULL,
      '',
      NULL,
      1,
      3,
      3.072214,
      2.009080,
      0.033168,
      NULL,
      0,
      1.047977);
commit;
end;
/


