set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7403992';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '303',
      NULL,
      55.857020,
      52,
      '0010344',
      136.123669,
      4,
      1.293058,
      3,
      '204103',
      NULL,
      NULL,
      58,
      43,
      0,
      NULL,
      0,
      0,
      0.967350,
      0.813809,
      1.151207,
      0.571424,
      1.498834,
      1,
      0,
      1,
      4.707379,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0.879621,
      NULL,
      1.924483,
      NULL,
      0.123293,
      2,
      NULL,
      1.587446,
      0.868606,
      0.565559,
      0.197975,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      0,
      1.689867,
      NULL,
      1.252633,
      0.629809,
      0,
      1.615596,
      NULL,
      0,
      2,
      1,
      NULL,
      2.210039,
      0,
      1.112078,
      1,
      2.342155,
      3.025886,
      1,
      1.851444,
      NULL,
      2.685712,
      1,
      1,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.267387,
      0.249579,
      0,
      0,
      3.742898,
      4.911101,
      5.052754,
      NULL,
      3.772761,
      NULL,
      0,
      0.807401,
      0,
      NULL,
      NULL,
      1.217934,
      0.150528,
      0,
      1.059828,
      NULL,
      NULL,
      1.316430,
      2.308602,
      NULL,
      NULL,
      0,
      2.853392,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.703815,
      1,
      1,
      3.371026,
      5,
      7.601349,
      1,
      9.724837,
      1,
      3,
      9.495606,
      6.228404,
      8,
      NULL,
      1,
      1,
      1.507108,
      NULL,
      NULL,
      0,
      0.477533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.822038,
      NULL,
      0,
      NULL,
      0,
      1.767669,
      0,
      0.514626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.407277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1,
      0,
      1.256994,
      NULL,
      NULL,
      NULL,
      0.663784,
      0,
      0.202019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.074608,
      1,
      1,
      0.374392,
      0,
      NULL,
      NULL,
      3.098810,
      NULL,
      NULL,
      1,
      0,
      0.859847,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.787322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      0.480254,
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      2.951532,
      2,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0.302208,
      5);
commit;
end;
/


