set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7403992';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '231',
      '22102214',
      25.366823,
      NULL,
      NULL,
      88.760990,
      5,
      NULL,
      3,
      '330001',
      NULL,
      ' 6-26-1997',
      64,
      NULL,
      0.335141,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.680893,
      1.953769,
      0,
      0.935031,
      NULL,
      1.120552,
      0.896622,
      0.804926,
      NULL,
      1.905529,
      1.829080,
      1.012251,
      0,
      1.720291,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.531743,
      NULL,
      NULL,
      NULL,
      0.573112,
      NULL,
      1,
      0,
      0,
      3,
      0,
      1,
      0,
      0,
      3,
      0.584531,
      3.292472,
      1,
      0,
      0.387733,
      NULL,
      2.694733,
      1.690796,
      0,
      1,
      5.322080,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      2,
      5,
      NULL,
      NULL,
      1.934393,
      5,
      4,
      1,
      1.398817,
      NULL,
      0,
      NULL,
      1.976545,
      1.687459,
      1.421403,
      NULL,
      1,
      NULL,
      3.530809,
      NULL,
      1,
      1.375505,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.045556,
      3,
      0.493630,
      9,
      NULL,
      6.305523,
      4.553443,
      2,
      NULL,
      3.266881,
      7,
      0,
      1.699142,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.344440,
      1,
      NULL,
      NULL,
      0.986482,
      1.007535,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.109349,
      3.903286,
      1,
      NULL,
      NULL,
      NULL,
      0.000083,
      0,
      3,
      2.809288,
      0,
      NULL,
      1.363305,
      NULL,
      NULL,
      NULL,
      1.099663,
      0,
      0.063875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.933910,
      3.500348,
      3.738500,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.851155,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      1.515184,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.581255,
      '43033',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      0.232799,
      '',
      '',
      '',
      1.803995,
      2.942447,
      NULL,
      NULL,
      3.208601,
      NULL,
      NULL,
      2,
      NULL);
commit;
end;
/


