set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7403992';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      77.064467,
      NULL,
      NULL,
      90,
      4,
      NULL,
      3,
      '214011',
      4,
      ' 2-16-2003',
      NULL,
      20.955512,
      1.151594,
      NULL,
      1,
      1.917487,
      NULL,
      0,
      1.090653,
      1,
      0,
      0,
      1.276645,
      0,
      3.579555,
      0.531329,
      NULL,
      0,
      0.121574,
      0,
      5.472210,
      1.738937,
      NULL,
      0.896583,
      NULL,
      1.973182,
      NULL,
      NULL,
      0.871844,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.389037,
      1.909085,
      NULL,
      0.744236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.545553,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.605382,
      1.476805,
      4.115838,
      0.826798,
      0.838253,
      1,
      1.072099,
      0.302776,
      0,
      0.300895,
      2,
      1.755566,
      0.667456,
      0,
      1.444604,
      1.282891,
      NULL,
      0.242335,
      0,
      3.779758,
      1,
      1,
      0.790474,
      2,
      3.381373,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      4.188188,
      0,
      0,
      2.195414,
      5.346101,
      0.257648,
      0.774369,
      NULL,
      5,
      5,
      NULL,
      3.049393,
      0,
      0.378743,
      NULL,
      NULL,
      2.669239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.239671,
      1,
      0,
      0,
      0,
      0,
      1.361994,
      0.135562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.101273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.352478,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.940280,
      3,
      NULL,
      1,
      2,
      0.230004,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.369551,
      3,
      0.002489,
      2.926412,
      1.334095,
      NULL,
      1,
      3,
      2,
      1,
      0.134177,
      NULL,
      0.188147,
      0.000305,
      0.214609,
      NULL,
      0,
      1.125036,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '43303',
      '',
      '',
      0.671066,
      '',
      '',
      '',
      1.550980,
      '',
      NULL,
      '',
      5,
      1.115108,
      1.168332,
      5,
      0,
      0.263563,
      3,
      NULL,
      3);
commit;
end;
/


