set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7403992';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '411',
      '01244013',
      52.869279,
      52.093425,
      '1002420',
      34.715339,
      6,
      3.323926,
      0,
      '333320',
      3.179971,
      NULL,
      NULL,
      24,
      NULL,
      NULL,
      1.679132,
      NULL,
      2,
      1.643101,
      1,
      0,
      1.112706,
      3.708972,
      0.237707,
      1,
      3,
      0.015027,
      1,
      3,
      NULL,
      0.395967,
      NULL,
      1,
      0,
      0.115796,
      1,
      NULL,
      0.380069,
      1,
      0.535103,
      NULL,
      0,
      1.708351,
      NULL,
      NULL,
      1.965469,
      NULL,
      NULL,
      NULL,
      1.104178,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.517131,
      1.268471,
      1.036657,
      1.398438,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.942008,
      1.744219,
      1.525548,
      0,
      1,
      NULL,
      1.898723,
      0,
      1.057105,
      1,
      4.891097,
      NULL,
      0.134231,
      2,
      1.894042,
      0.141083,
      1.719787,
      0.714925,
      1,
      NULL,
      1,
      0.816138,
      NULL,
      0,
      NULL,
      1,
      3.236079,
      0.081890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      2,
      NULL,
      5.309699,
      1,
      NULL,
      5.012655,
      2.099345,
      0.574720,
      1.460018,
      NULL,
      1,
      0,
      NULL,
      NULL,
      4,
      1.700329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.298265,
      0,
      2,
      0,
      1,
      1.571536,
      0,
      1.430497,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.581858,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.542569,
      4.072097,
      NULL,
      1.004553,
      0,
      1.304357,
      NULL,
      NULL,
      NULL,
      1.565476,
      1.915876,
      0.264344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.234258,
      NULL,
      0.144885,
      1,
      1,
      0.264550,
      1,
      1.922242,
      NULL,
      0,
      NULL,
      0,
      0.067789,
      0,
      1.058618,
      0,
      0.290933,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      '',
      '',
      0.391722,
      '',
      '',
      '',
      0.014451,
      '',
      '',
      '',
      3.231858,
      0,
      NULL,
      NULL,
      4,
      3.063228,
      1,
      0.914037,
      NULL);
commit;
end;
/


