set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7403992';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2231',
      '23222224',
      47.135951,
      6,
      NULL,
      NULL,
      NULL,
      3.315373,
      1,
      '043043',
      6.002539,
      ' 0-25-1989',
      NULL,
      20,
      0.221871,
      NULL,
      0,
      NULL,
      2.169221,
      NULL,
      0.267171,
      1.275978,
      1,
      3,
      1.684614,
      0,
      2.180079,
      0.214423,
      1.824313,
      NULL,
      0,
      0,
      5,
      NULL,
      1.509650,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      2.367365,
      NULL,
      0.019418,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.497413,
      1.080271,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.223238,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.491039,
      1.171772,
      NULL,
      NULL,
      0.833470,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.795845,
      1,
      0.689526,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.812186,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.794359,
      NULL,
      0.238702,
      2,
      3,
      5,
      NULL,
      4,
      1.608790,
      1,
      7.921825,
      8.317484,
      NULL,
      1.447347,
      0.786102,
      2,
      0,
      NULL,
      NULL,
      9.290276,
      1.768193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.861961,
      1,
      1,
      1.685075,
      1.644182,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.660032,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.258634,
      0,
      2,
      0,
      1,
      2,
      0.876138,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.051579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.066598,
      NULL,
      2.917062,
      0.148809,
      NULL,
      0.671378,
      0,
      2,
      1,
      3.405940,
      0,
      0.923502,
      NULL,
      NULL,
      0,
      0.788006,
      0,
      1.374432,
      0,
      1.201520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.484848,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '',
      '',
      1,
      NULL,
      '',
      '',
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      2.483185,
      1,
      NULL);
commit;
end;
/


