set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9132494';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-8-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      NULL,
      NULL,
      '0420241',
      NULL,
      4,
      2.022569,
      NULL,
      NULL,
      0.243600,
      NULL,
      38,
      NULL,
      NULL,
      NULL,
      17.215754,
      1.279578,
      NULL,
      1.075516,
      NULL,
      0.803437,
      0.151023,
      NULL,
      0,
      0.895925,
      1.063908,
      NULL,
      1.261622,
      0.344547,
      1,
      0,
      1,
      1.642901,
      0,
      0.164750,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.706630,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.078584,
      1,
      1.001675,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.391302,
      1.537714,
      NULL,
      2,
      1.630064,
      2.923891,
      0.649817,
      0.606732,
      0.465735,
      3.269699,
      NULL,
      0,
      NULL,
      NULL,
      1.320203,
      1.447761,
      1.133079,
      0,
      NULL,
      NULL,
      2.298247,
      0.527305,
      NULL,
      1.161076,
      NULL,
      3.631359,
      0,
      NULL,
      NULL,
      0.594111,
      0,
      1.393035,
      0,
      NULL,
      NULL,
      NULL,
      0.741747,
      0,
      NULL,
      NULL,
      1.708053,
      NULL,
      6,
      NULL,
      1.772243,
      3,
      1,
      0.907471,
      NULL,
      NULL,
      9.367345,
      1.975150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.604077,
      0.331634,
      NULL,
      0,
      0,
      0.779507,
      0,
      0.676525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.784772,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      0.290916,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.696798,
      0,
      1.616675,
      1,
      1.412247,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.470157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.853047,
      1,
      1.905696,
      0.842418,
      1,
      NULL,
      2,
      1.029722,
      1,
      NULL,
      NULL,
      0,
      1,
      1.583951,
      1.155294,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.976890,
      '',
      '',
      '',
      NULL,
      '41440',
      '14342',
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


