set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9132494';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-1-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '103',
      '24234403',
      NULL,
      19.359882,
      '0220124',
      24.149646,
      NULL,
      0,
      NULL,
      '430040',
      NULL,
      '10-11-1985',
      NULL,
      26,
      1,
      NULL,
      NULL,
      NULL,
      3.054781,
      NULL,
      1.175657,
      NULL,
      1.598380,
      1.355757,
      0,
      0.790729,
      0,
      1,
      1.841806,
      0.696439,
      NULL,
      1.367000,
      4,
      1.777584,
      NULL,
      1.516002,
      0,
      1.610534,
      2,
      0,
      2,
      2,
      1.830056,
      1,
      NULL,
      NULL,
      0.320010,
      NULL,
      NULL,
      1.128718,
      1.408639,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.621315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.737667,
      0.172547,
      3,
      0,
      NULL,
      0.382010,
      NULL,
      1.863900,
      1.292102,
      NULL,
      NULL,
      0.415226,
      1.959458,
      1,
      0.043585,
      0,
      1,
      NULL,
      0.181818,
      4.508109,
      1.081551,
      1,
      0.484975,
      0.891128,
      1,
      0,
      2.730998,
      1,
      NULL,
      0.931246,
      NULL,
      0.021651,
      1.718296,
      1.377300,
      3.092186,
      6.993496,
      6,
      0,
      9,
      1.364910,
      3.481498,
      2.715292,
      5.043571,
      4.050509,
      1.233091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.129941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      0.597925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.157275,
      NULL,
      9.929660,
      0.263619,
      3,
      4.454680,
      1.282823,
      1,
      0,
      0.610858,
      3.056375,
      6,
      0,
      1.033502,
      NULL,
      NULL,
      NULL,
      0.513998,
      5.616549,
      NULL,
      NULL,
      0,
      1,
      0.976930,
      NULL,
      NULL,
      NULL,
      1,
      10,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.022770,
      3.209909,
      3,
      1,
      0,
      3.163224,
      0.856835,
      3,
      3,
      3.131659,
      1,
      NULL,
      1.269017,
      1.309910,
      1,
      0,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '44211',
      '',
      '',
      5.796560,
      NULL,
      '32310',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      1.160333,
      1.047237,
      7.450117,
      NULL,
      6.821795,
      2.554919,
      1,
      0);
commit;
end;
/


