set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9132494';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-4-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '244',
      '23',
      16.826149,
      3.286608,
      NULL,
      NULL,
      6,
      3.904488,
      1,
      '122332',
      0,
      ' 7-15-1995',
      39.949991,
      24,
      1.987672,
      NULL,
      15,
      1.811258,
      0.769378,
      1.150289,
      0.303725,
      1,
      1.237241,
      0.354158,
      3.712842,
      1.081833,
      0.743758,
      1.638402,
      1.185594,
      0.641156,
      1.432126,
      1.900275,
      3.056249,
      1.184528,
      1.796442,
      1,
      0,
      1.681393,
      0.273132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.938359,
      1.329003,
      0.095218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.201415,
      0.632265,
      0.537496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.077834,
      2.545084,
      2,
      0,
      3,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.305440,
      0.393480,
      0.103899,
      1,
      1.131587,
      0.689217,
      1.399416,
      0,
      NULL,
      1.432013,
      0.762333,
      5.173577,
      1.186502,
      0,
      0,
      0.465748,
      0,
      1,
      NULL,
      0,
      NULL,
      1.070738,
      0,
      1,
      NULL,
      NULL,
      4,
      5.940160,
      NULL,
      2,
      NULL,
      4.454212,
      NULL,
      1.432313,
      4.166862,
      0.763090,
      2.310308,
      NULL,
      NULL,
      NULL,
      4,
      0.369137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.215500,
      0,
      0,
      NULL,
      1,
      0.392240,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.203494,
      3,
      NULL,
      NULL,
      0,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.908357,
      NULL,
      0.196934,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.898864,
      1.379189,
      1.784558,
      1.855028,
      0,
      1.166081,
      1.811356,
      1,
      0,
      1,
      0,
      0.759775,
      1,
      NULL,
      1.431327,
      1,
      NULL,
      0.791113,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '34114',
      '',
      '',
      2.664379,
      NULL,
      '',
      '',
      1,
      '',
      '',
      NULL,
      1.723865,
      3.394523,
      1,
      3,
      NULL,
      3.684292,
      2,
      0,
      1.744827);
commit;
end;
/


