set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9132494';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-5-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      17.231607,
      NULL,
      '4313112',
      NULL,
      2,
      1.647968,
      1,
      '123210',
      2,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      7,
      0.176624,
      2,
      NULL,
      NULL,
      1.919326,
      1.280891,
      1.028021,
      0.191108,
      1.515228,
      0.521294,
      1,
      0.304747,
      1,
      0.041347,
      3.206187,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      5,
      1,
      1,
      2.769966,
      2,
      NULL,
      NULL,
      NULL,
      0.234776,
      NULL,
      NULL,
      0,
      1.756923,
      0.535170,
      0.070036,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.061074,
      NULL,
      2.565771,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.240912,
      2,
      2,
      2,
      3.567445,
      0.182263,
      0.139062,
      0.916618,
      1,
      0,
      1,
      0,
      1.047308,
      0.848134,
      0.111376,
      0.381159,
      0,
      1,
      0,
      NULL,
      1,
      0.364605,
      1.829104,
      1.635186,
      1,
      0,
      5,
      0,
      2,
      0,
      4.601176,
      3,
      3,
      0,
      0,
      0.441803,
      0.119369,
      4.250436,
      2.003249,
      6,
      3.196358,
      5.968093,
      7,
      11,
      6,
      NULL,
      2,
      NULL,
      0.496297,
      0.142824,
      0.676341,
      8.348104,
      0.643852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.098842,
      0,
      0,
      1,
      0,
      NULL,
      0.838162,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.727328,
      2,
      NULL,
      3.770925,
      1,
      0.553847,
      2,
      NULL,
      1,
      3.765142,
      0.061412,
      0,
      3.982809,
      1.716804,
      NULL,
      1,
      1,
      2,
      0.547949,
      NULL,
      0,
      1.727840,
      0,
      NULL,
      NULL,
      0,
      2.629608,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.037766,
      0,
      1,
      0.624660,
      1,
      NULL,
      2,
      1,
      1,
      1,
      1.554733,
      0,
      NULL,
      0,
      0,
      NULL,
      1.483401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.633758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      '',
      '',
      3.697898,
      '21013',
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      4,
      NULL,
      1,
      3,
      0,
      NULL,
      1,
      2.020004,
      3);
commit;
end;
/


