set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9132494';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3214',
      '22341113',
      26,
      58,
      '4113232',
      220.428695,
      NULL,
      1.958913,
      2,
      NULL,
      6,
      NULL,
      18.382943,
      60.590591,
      0.756936,
      NULL,
      13.821501,
      0.219713,
      1,
      0.808923,
      NULL,
      3.576513,
      0.131342,
      1,
      2,
      1.824491,
      0,
      0,
      1,
      0.853933,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0.752350,
      0,
      3.735416,
      1,
      3.654520,
      0.799864,
      NULL,
      1,
      NULL,
      NULL,
      0.377517,
      NULL,
      NULL,
      1,
      0.312890,
      NULL,
      1.798022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.269657,
      0.016825,
      0,
      1.422954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.881428,
      NULL,
      1,
      0.416798,
      1,
      1,
      0,
      1,
      1,
      NULL,
      0.595691,
      1.643557,
      1,
      1,
      1,
      NULL,
      NULL,
      0.784197,
      3.949303,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.347653,
      0,
      NULL,
      1.021833,
      5.313141,
      2,
      5,
      NULL,
      3,
      NULL,
      6,
      3.537383,
      4,
      7.058263,
      3.260576,
      6,
      5.789583,
      NULL,
      2.289570,
      3,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.649876,
      NULL,
      0,
      0,
      NULL,
      0,
      0.053649,
      1.819893,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.786023,
      1.540500,
      0,
      1,
      2.678271,
      0,
      NULL,
      0.204760,
      NULL,
      NULL,
      NULL,
      0,
      0.350410,
      0,
      1,
      1.637478,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.120936,
      3.955095,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.204136,
      2,
      0,
      0,
      3,
      1,
      2.761765,
      0.983204,
      3,
      0.469339,
      0.947984,
      1.658015,
      NULL,
      1.646710,
      1.007301,
      NULL,
      NULL,
      0.606387,
      0.435555,
      1.180998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.989100,
      '23130',
      '',
      '',
      1.278365,
      '31104',
      '',
      '',
      1.710044,
      '',
      '',
      NULL,
      5.256219,
      2,
      0.574591,
      4.021120,
      2.825986,
      0,
      3.846969,
      2,
      NULL);
commit;
end;
/


