set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9132494';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2121',
      NULL,
      76,
      45,
      '3140020',
      99,
      4,
      NULL,
      0,
      '200444',
      0,
      ' 5-27-1975',
      11.596904,
      9,
      0,
      NULL,
      17.107311,
      0,
      3.992947,
      1.072868,
      1,
      0.295730,
      1.141717,
      0,
      2,
      1.873486,
      0.215149,
      1.254338,
      0,
      1,
      0.287104,
      0,
      1,
      0,
      0,
      0.876200,
      0,
      1,
      1.793456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.676391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.042623,
      3.231486,
      1.377036,
      3,
      1.156404,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      1.416554,
      0,
      NULL,
      1.484811,
      1.852050,
      1,
      NULL,
      0.438243,
      1.944258,
      NULL,
      0.421990,
      4,
      1.219273,
      1,
      0.402171,
      NULL,
      1.609459,
      5.813962,
      2,
      5,
      1.363959,
      NULL,
      1.999377,
      2,
      6.982637,
      3.050158,
      1,
      4.721370,
      5,
      6.133257,
      9,
      6,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      4.906497,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.357461,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1.154251,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.590233,
      NULL,
      NULL,
      NULL,
      NULL,
      0.041895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.414905,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.440581,
      0.980373,
      1,
      1.245340,
      NULL,
      NULL,
      NULL,
      1.945199,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.968040,
      1,
      1.379380,
      1.907085,
      0,
      3.331989,
      0.117381,
      NULL,
      3.164309,
      0,
      1.814685,
      1.023987,
      0.729155,
      1.055748,
      0.336941,
      1,
      1.575486,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.844356,
      '30130',
      '',
      '',
      2,
      '23340',
      '12014',
      '',
      0.265098,
      NULL,
      '',
      '',
      4.815484,
      3.719129,
      0.940581,
      1,
      3,
      3.412305,
      2.642205,
      NULL,
      NULL);
commit;
end;
/


