set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9839660';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      61.382212,
      52,
      NULL,
      9,
      4,
      2.263162,
      2,
      '132142',
      2.218075,
      ' 5- 2-1988',
      37.372850,
      8,
      NULL,
      NULL,
      4.970485,
      0,
      0,
      1,
      3.956107,
      1,
      2.726905,
      0,
      1,
      1.968966,
      7,
      0,
      0.474587,
      0.736625,
      NULL,
      1.949080,
      NULL,
      0,
      9.930374,
      0.441352,
      1,
      0,
      7.495944,
      1,
      0.120896,
      1.897535,
      NULL,
      0,
      NULL,
      NULL,
      0.672389,
      NULL,
      NULL,
      5.997019,
      NULL,
      0,
      1.990627,
      1.965933,
      0,
      3,
      2,
      0,
      1.337193,
      1,
      1.890835,
      0.460543,
      2,
      0,
      2,
      1,
      3,
      3,
      1.354953,
      0,
      0,
      7.604264,
      1,
      1,
      2.894568,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      0.201537,
      3.836830,
      NULL,
      NULL,
      0.036918,
      0,
      1,
      NULL,
      NULL,
      1.786397,
      NULL,
      0.969573,
      0,
      1,
      0.194787,
      1.346901,
      NULL,
      NULL,
      0,
      2,
      1,
      0,
      5,
      0.350898,
      2.713841,
      NULL,
      3,
      1.723386,
      1,
      1,
      NULL,
      1,
      3.887548,
      NULL,
      NULL,
      9,
      7.005681,
      8,
      7.541632,
      NULL,
      NULL,
      0.564577,
      3.828680,
      0.214907,
      0.869456,
      0,
      1.653382,
      0.954898,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      1.472935,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.449146,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1.793690,
      0.652237,
      3.245112,
      NULL,
      0.298763,
      NULL,
      NULL,
      NULL,
      NULL,
      0.285182,
      0,
      1.868991,
      5,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      6,
      1.445798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.440699,
      NULL,
      2.904331,
      0,
      0,
      1,
      1,
      1.663052,
      NULL,
      3.969422,
      1,
      NULL,
      0,
      1.557610,
      NULL,
      1.564785,
      0,
      0.807519,
      1.842349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '00004',
      '',
      '',
      0.337604,
      '',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      2,
      1,
      3.480426,
      3,
      5,
      2.121633,
      1.202572,
      0,
      3.747805);
commit;
end;
/


