set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9839660';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-6-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '310',
      '10230223',
      40.342921,
      29,
      '0311123',
      17.602556,
      3,
      2.665427,
      3,
      NULL,
      1,
      ' 6- 7-1980',
      12,
      4,
      0.683739,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.174830,
      NULL,
      1,
      1,
      0,
      6.439930,
      1.160610,
      0.888090,
      1.666866,
      0.900277,
      1.102937,
      1.078178,
      1,
      3,
      NULL,
      1.825728,
      0,
      6,
      NULL,
      4,
      1.601931,
      0,
      1.821836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      6,
      3.750508,
      3,
      1.320905,
      1.453055,
      2.673960,
      0.061438,
      2.261534,
      3,
      0,
      2.154860,
      NULL,
      2.467907,
      1.772609,
      0,
      0.791899,
      0,
      1.888780,
      0,
      0,
      0.185372,
      9,
      1,
      1,
      3.595288,
      1.253566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.077731,
      5,
      1,
      2,
      2.934988,
      1.575442,
      0.558649,
      NULL,
      0,
      NULL,
      1,
      1.803865,
      1,
      0,
      NULL,
      1,
      0.479939,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0.410472,
      0,
      NULL,
      1.135867,
      4.790894,
      1.343570,
      NULL,
      0,
      1,
      0.493962,
      NULL,
      NULL,
      1,
      5,
      7.972174,
      9,
      NULL,
      NULL,
      6,
      7.650601,
      3,
      0.314074,
      NULL,
      1,
      0.730462,
      NULL,
      0.461999,
      1,
      1.336885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.792641,
      1,
      0,
      1.095684,
      1.062511,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.846761,
      1,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.410729,
      5.755867,
      0.164988,
      1.323060,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.654584,
      7,
      1.958419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.496578,
      1,
      2.820926,
      1,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0.292014,
      0.418980,
      NULL,
      NULL,
      0.578480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '12204',
      '',
      '',
      0.765389,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0.198350,
      0.677891,
      NULL,
      0.094456,
      1.943182,
      0,
      NULL,
      1,
      0);
commit;
end;
/


