set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9839660';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '334',
      NULL,
      80.659727,
      33,
      '0411443',
      29.334417,
      2,
      1.662968,
      2,
      '332404',
      3,
      '10- 6-1981',
      2,
      32.804110,
      1.174623,
      NULL,
      1,
      3,
      1.331359,
      1,
      NULL,
      1,
      1.422414,
      1.604672,
      3,
      1,
      NULL,
      0,
      1.374225,
      1.509574,
      0.209057,
      1,
      NULL,
      1.404282,
      3.929520,
      0.176121,
      0,
      1.833441,
      0,
      NULL,
      5.800400,
      NULL,
      3,
      0.674000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.018841,
      4.083284,
      3,
      1.273714,
      0.944136,
      1.308491,
      1,
      NULL,
      2.311268,
      1,
      1.119025,
      1.331627,
      3.731593,
      NULL,
      2.030487,
      1,
      0.728812,
      3.215164,
      0,
      1,
      0.694052,
      5.913392,
      0,
      NULL,
      1.090166,
      1.232646,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.806738,
      1.878657,
      0,
      2,
      NULL,
      NULL,
      0,
      NULL,
      0.712464,
      0.081039,
      1,
      0.813133,
      1,
      0.950150,
      0.975459,
      1,
      1,
      0.881222,
      1,
      NULL,
      1,
      1,
      1.885027,
      0.311136,
      0,
      NULL,
      3.744642,
      1.821671,
      3,
      NULL,
      5,
      0.454758,
      NULL,
      1,
      6,
      0.950519,
      1,
      1.441677,
      NULL,
      1.705515,
      7,
      4.673146,
      3,
      NULL,
      5,
      1,
      1.299342,
      0,
      0.030989,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.904086,
      0,
      1,
      1.951947,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      3.933429,
      NULL,
      1.634499,
      1,
      7,
      0.022737,
      1,
      NULL,
      NULL,
      NULL,
      0.696797,
      1.594080,
      NULL,
      2.014612,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      1,
      1.110454,
      2,
      NULL,
      2,
      1,
      2.886645,
      1.391427,
      1.824002,
      NULL,
      0.270122,
      1.035827,
      1,
      1,
      0.766954,
      0,
      0.993808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.141153,
      NULL,
      '',
      '',
      1.353472,
      '',
      '',
      '',
      1.788975,
      '',
      '',
      NULL,
      NULL,
      2.344044,
      1,
      0.625915,
      1.930392,
      1,
      0,
      3,
      3.978888);
commit;
end;
/


