set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9839660';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-1-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2300',
      NULL,
      15,
      NULL,
      NULL,
      57,
      1,
      NULL,
      3,
      '443013',
      3.487158,
      ' 0-17-1997',
      NULL,
      6,
      NULL,
      NULL,
      1.620876,
      1.796697,
      NULL,
      1,
      NULL,
      NULL,
      1.260404,
      0.528784,
      2,
      0.720244,
      5,
      0,
      0,
      1,
      0,
      1,
      NULL,
      0.464238,
      1,
      1,
      0.809819,
      1.012865,
      5.818270,
      1,
      2.023740,
      2.150011,
      NULL,
      0.992715,
      NULL,
      NULL,
      0.623608,
      NULL,
      NULL,
      NULL,
      0,
      2.566540,
      0,
      1,
      NULL,
      1.437642,
      0.983487,
      2,
      NULL,
      1.584549,
      NULL,
      1.551180,
      1,
      3,
      3,
      1.329517,
      0.101496,
      0.755537,
      0,
      1,
      1,
      5.236246,
      0,
      2,
      3,
      0.502068,
      NULL,
      NULL,
      0.892714,
      NULL,
      NULL,
      0,
      1.969734,
      1,
      1,
      NULL,
      NULL,
      0.674812,
      0,
      0,
      0,
      0,
      NULL,
      0,
      0.967750,
      0,
      0.067192,
      0,
      0,
      1.051576,
      NULL,
      0,
      4,
      0.295797,
      NULL,
      NULL,
      NULL,
      0.244139,
      1,
      6,
      3.886339,
      NULL,
      0.206594,
      1,
      NULL,
      NULL,
      1,
      1.892545,
      4.565978,
      0.807634,
      5.811329,
      7.666664,
      NULL,
      1.838409,
      NULL,
      0.687288,
      0.637224,
      0,
      0.509409,
      3.919363,
      1.288456,
      NULL,
      0.920680,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.303611,
      0,
      0,
      0.959860,
      1,
      1,
      0.641023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.620410,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.613073,
      0.385052,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      NULL,
      1,
      1,
      0.716462,
      NULL,
      NULL,
      NULL,
      0.514791,
      0.199616,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.697567,
      NULL,
      0,
      1,
      0,
      1.182189,
      0.614364,
      2,
      0,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.696383,
      1,
      0,
      1.622657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.442637,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '03303',
      NULL,
      '',
      1.295761,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      1.418673,
      3.501311,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL);
commit;
end;
/


