set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9839660';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      7.888789,
      57.574813,
      '4122234',
      48,
      0,
      3,
      1,
      '112310',
      0,
      ' 0-22-1986',
      41.546034,
      42,
      1,
      NULL,
      1,
      0,
      2.115524,
      1.903931,
      1.924829,
      0,
      0,
      1,
      1.377902,
      0,
      0.992759,
      1.121586,
      0,
      0,
      0.322214,
      NULL,
      4,
      NULL,
      1,
      NULL,
      0.383421,
      0.318528,
      6.279630,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      2,
      4.772821,
      2.216434,
      NULL,
      NULL,
      3.551272,
      3,
      1,
      1.637357,
      1,
      3,
      1.780514,
      2,
      3.908753,
      2.568722,
      NULL,
      NULL,
      0.138307,
      1,
      1.180894,
      1,
      4,
      1,
      2,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.221345,
      1,
      1.901688,
      NULL,
      1.825005,
      1,
      1,
      0.153359,
      NULL,
      0,
      1.890466,
      0,
      1.370612,
      0.474997,
      0.967586,
      NULL,
      0.100023,
      0.538477,
      NULL,
      NULL,
      NULL,
      NULL,
      1.675475,
      1,
      1.322155,
      1,
      5,
      0.667683,
      NULL,
      3,
      NULL,
      0.019072,
      1.219860,
      1.801236,
      5.444010,
      0,
      0.577124,
      2.383707,
      0,
      NULL,
      9,
      4.458138,
      NULL,
      1,
      0.544610,
      1,
      1.260718,
      1.853002,
      NULL,
      1.949898,
      1.966410,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.298358,
      NULL,
      1,
      2.087108,
      1.760070,
      1.822523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.929241,
      0.360710,
      2,
      1.810462,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2,
      1.594461,
      2.889298,
      1.969138,
      NULL,
      NULL,
      3.851160,
      1,
      1.524758,
      1.205032,
      0,
      1.084764,
      0.283334,
      NULL,
      1.527327,
      0.413615,
      0.857765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '13401',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0.380454,
      '',
      '',
      '',
      0.824614,
      1,
      1.527410,
      0.582470,
      2.610127,
      0,
      NULL,
      2,
      0);
commit;
end;
/


