set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9839660';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-2-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0140',
      '00104410',
      43.406768,
      10.043847,
      '1034304',
      42,
      6,
      NULL,
      2,
      '300312',
      3,
      ' 6-21-1987',
      2.265725,
      42,
      0,
      NULL,
      4,
      0.961473,
      1.300317,
      NULL,
      0,
      0.014036,
      0.503550,
      1.336707,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.154113,
      0,
      1,
      10,
      0.748590,
      9,
      NULL,
      1.502461,
      0.730187,
      1,
      0,
      0.203135,
      0.834042,
      2,
      1.241366,
      NULL,
      NULL,
      1.528985,
      NULL,
      NULL,
      NULL,
      2.200632,
      2,
      3,
      0,
      0,
      0,
      2,
      0.511263,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0.238365,
      1.108350,
      0,
      1,
      1,
      0,
      1,
      0,
      2.313978,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      0.178989,
      NULL,
      0.241840,
      NULL,
      NULL,
      0.320411,
      1.447441,
      0.745984,
      1,
      1.221286,
      1,
      0.375267,
      0.765109,
      1,
      NULL,
      1,
      4,
      1,
      0.767740,
      1,
      NULL,
      NULL,
      0.633676,
      1.780707,
      NULL,
      5.963000,
      0,
      NULL,
      7,
      4,
      0.618573,
      1,
      5.928661,
      0.384425,
      NULL,
      4.598284,
      3,
      2.624026,
      0.699512,
      7,
      1,
      1,
      0.305389,
      0,
      1,
      1.816234,
      NULL,
      1.993519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.134090,
      0,
      NULL,
      1.737368,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.222530,
      NULL,
      7,
      1.652466,
      0,
      2.784512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.878669,
      NULL,
      NULL,
      NULL,
      NULL,
      1.282795,
      1.198869,
      NULL,
      0.606740,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      4.280956,
      1.405770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.437063,
      2.691324,
      1,
      0.009581,
      0,
      2.652312,
      0.751382,
      3.932043,
      0,
      1.558856,
      1.599806,
      1.308755,
      1,
      1,
      1,
      0,
      0.459586,
      1.036054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '42042',
      '',
      '',
      0.067694,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      3.775650,
      3,
      2,
      NULL,
      0,
      2,
      3.266065,
      3.887164,
      0.479347);
commit;
end;
/


