set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9402223';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-2-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      44.132711,
      29.606983,
      NULL,
      8,
      1,
      2,
      NULL,
      '030140',
      2,
      ' 6-16-1977',
      7.700963,
      31.738125,
      1,
      NULL,
      NULL,
      1.021341,
      0,
      0.120859,
      NULL,
      NULL,
      1.271032,
      1.816245,
      2,
      1.201865,
      0.342749,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      1.491685,
      1.160884,
      0.422800,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.472258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.034921,
      0,
      NULL,
      1,
      1.566250,
      NULL,
      NULL,
      1.346717,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.694662,
      NULL,
      0.847618,
      0.210128,
      NULL,
      1,
      NULL,
      0,
      0,
      0.323866,
      NULL,
      1,
      0.958716,
      1.639016,
      1,
      1.537405,
      NULL,
      0.789051,
      0,
      1.203985,
      0.334604,
      1.892345,
      0.382355,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.933376,
      0,
      NULL,
      1,
      1.682333,
      0,
      NULL,
      2.817573,
      NULL,
      NULL,
      3.240742,
      3,
      1,
      0.012336,
      1.737491,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.675602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.056068,
      0,
      NULL,
      1,
      0,
      0.529516,
      1.722263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.322926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.707926,
      0.081613,
      1,
      NULL,
      1.165973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.923540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.648067,
      0.643080,
      3.673976,
      NULL,
      NULL,
      NULL,
      0.992524,
      1.233507,
      1.167821,
      1.223650,
      0,
      0,
      1.606184,
      0,
      1,
      0.139825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '43031',
      '',
      '',
      1.430178,
      NULL,
      NULL,
      NULL,
      0.689767,
      NULL,
      '',
      '',
      NULL,
      1,
      2,
      NULL,
      NULL,
      1,
      2.390686,
      0.642655,
      3.271844);
commit;
end;
/


