set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8934076';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-1-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      NULL,
      NULL,
      '3043213',
      11,
      4,
      3.850429,
      1,
      '303310',
      1.682348,
      ' 3-20-2002',
      3,
      NULL,
      0,
      NULL,
      2,
      3.330019,
      NULL,
      NULL,
      NULL,
      NULL,
      1.581856,
      1.584126,
      NULL,
      0.249744,
      NULL,
      1,
      1.130503,
      NULL,
      NULL,
      1.535305,
      1,
      0.566775,
      1,
      NULL,
      1,
      0.332407,
      2,
      0,
      1,
      1,
      NULL,
      0.938224,
      NULL,
      NULL,
      1.083046,
      NULL,
      NULL,
      1.501688,
      1.669090,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.768916,
      0.834263,
      2.972670,
      1.482006,
      1.590134,
      0,
      1.851889,
      0.541930,
      0,
      NULL,
      NULL,
      2.335371,
      2.552997,
      0,
      0,
      1.263169,
      0.660660,
      NULL,
      NULL,
      0.440471,
      NULL,
      NULL,
      1.566214,
      5,
      1.232161,
      0,
      NULL,
      2,
      0.727787,
      1.093388,
      1.207804,
      0.870513,
      1,
      NULL,
      1.788535,
      3,
      0.547641,
      0.444289,
      1.506623,
      1,
      0.958280,
      NULL,
      1.110409,
      NULL,
      1,
      1,
      1,
      1.026120,
      0,
      1,
      4,
      0.644965,
      0.084594,
      0,
      NULL,
      3.233337,
      1.591138,
      0,
      0,
      5,
      1,
      NULL,
      8,
      NULL,
      4,
      NULL,
      0.178966,
      2,
      2.331319,
      2,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.496305,
      0.345703,
      0,
      1,
      1,
      0.106068,
      0.618273,
      0.324021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      8,
      2,
      0.332693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.944142,
      0.361148,
      1,
      NULL,
      NULL,
      NULL,
      4,
      0,
      3,
      0,
      1.028034,
      NULL,
      0.401914,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.182739,
      NULL,
      1.099068,
      1.962885,
      NULL,
      1,
      0,
      3,
      1.357531,
      1.642443,
      0,
      NULL,
      0,
      1,
      1.137948,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.733783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '30410',
      '',
      '',
      1,
      '',
      NULL,
      '',
      0.785039,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


