set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8934076';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-10-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '2',
      NULL,
      NULL,
      '0044124',
      9.057320,
      4,
      1.734464,
      3,
      '304413',
      0.714216,
      ' 8-25-1994',
      NULL,
      NULL,
      0.126146,
      NULL,
      2.255126,
      0.750748,
      NULL,
      NULL,
      0.617410,
      0.195530,
      NULL,
      0.610314,
      0.932316,
      1.454908,
      NULL,
      0,
      0,
      0.581783,
      0.676630,
      1,
      3,
      0,
      0.827101,
      1.981036,
      NULL,
      0,
      NULL,
      1,
      2,
      NULL,
      0.293817,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8.965005,
      0,
      0.306246,
      NULL,
      3,
      2,
      0.913820,
      3.767945,
      NULL,
      0,
      1,
      1,
      3.808695,
      1.528133,
      0,
      0.994856,
      1,
      1,
      0.185006,
      NULL,
      NULL,
      1.807989,
      6,
      NULL,
      2,
      0.535936,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.815588,
      NULL,
      1.338789,
      0,
      2.762844,
      2.953643,
      3,
      0,
      0,
      NULL,
      0,
      NULL,
      0.201367,
      NULL,
      1,
      1,
      1,
      1.282130,
      1,
      NULL,
      1.694094,
      1.146321,
      1.759544,
      0,
      NULL,
      0,
      0.421351,
      1,
      3,
      NULL,
      3,
      1.110905,
      0.755881,
      3.585358,
      5.598446,
      1.921948,
      NULL,
      5,
      NULL,
      0.120511,
      9,
      0.744375,
      1.433244,
      1,
      0.120555,
      1.555643,
      5.273460,
      NULL,
      3.818232,
      0,
      0.727679,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.175447,
      NULL,
      0,
      0,
      1.923653,
      1.715503,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7,
      0.871033,
      0.832286,
      5,
      3,
      1,
      0.148910,
      NULL,
      3.001851,
      7.832850,
      3.252530,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.530413,
      NULL,
      1.033194,
      2,
      2,
      NULL,
      NULL,
      NULL,
      1.472562,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.178222,
      NULL,
      3.286784,
      NULL,
      1.518462,
      1,
      2,
      0,
      3,
      1.100664,
      1,
      NULL,
      0.683350,
      0.979915,
      0.698801,
      0,
      0.548744,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.063376,
      '02123',
      '',
      NULL,
      0,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


