set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8934076';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-3-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '3',
      NULL,
      NULL,
      '0441424',
      20.275977,
      1,
      2,
      0,
      '431303',
      2.341863,
      NULL,
      61.796642,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      3,
      0.618195,
      1.472994,
      NULL,
      0.465379,
      NULL,
      0.063676,
      3.274577,
      NULL,
      7,
      0,
      1.441435,
      0.813286,
      0,
      NULL,
      1.567217,
      0,
      4.752615,
      1,
      0.932640,
      0.994981,
      NULL,
      NULL,
      0.942128,
      NULL,
      NULL,
      NULL,
      NULL,
      1.891714,
      0,
      NULL,
      0.049274,
      1.964024,
      NULL,
      1,
      NULL,
      0,
      1.560871,
      2,
      2.288115,
      1,
      0,
      NULL,
      3.210601,
      3,
      1,
      0,
      1.833826,
      NULL,
      NULL,
      NULL,
      2.837514,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.110386,
      4,
      4.841484,
      1,
      5,
      5,
      NULL,
      1.582164,
      0,
      1,
      0.223060,
      0,
      1,
      0,
      1,
      1,
      0.043743,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.270737,
      NULL,
      1.006743,
      0.396964,
      1,
      3,
      NULL,
      2.171068,
      0.360880,
      0.068524,
      1.110654,
      NULL,
      0,
      1.282212,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      6.187437,
      4.627535,
      3,
      0.132097,
      2.997038,
      0,
      1.285640,
      1,
      5.104612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      1,
      1.357023,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.045190,
      NULL,
      9.321429,
      0.471575,
      NULL,
      1,
      1.106898,
      3,
      NULL,
      0.773349,
      0.710444,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.796746,
      1.919912,
      NULL,
      1.947096,
      2,
      3.726076,
      NULL,
      NULL,
      NULL,
      0,
      0.776729,
      1.343303,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2.382161,
      1.317128,
      NULL,
      0,
      3,
      1.508290,
      NULL,
      1.693644,
      0,
      0.154430,
      1.454921,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '21211',
      '',
      '',
      0.161288,
      '',
      '',
      '',
      0.261018,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


