set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8934076';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-9-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      NULL,
      NULL,
      '3340133',
      9.433511,
      NULL,
      1,
      1,
      '342240',
      1.739484,
      ' 3-19-1974',
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2.466462,
      0,
      0,
      3.883284,
      1,
      0.882363,
      3,
      NULL,
      NULL,
      1,
      NULL,
      0.856301,
      1,
      1,
      2,
      0,
      3.971201,
      1,
      1.400654,
      NULL,
      0,
      0,
      NULL,
      3.441998,
      1.325641,
      NULL,
      NULL,
      NULL,
      1.967848,
      NULL,
      NULL,
      9,
      NULL,
      0,
      3.465974,
      3,
      0,
      2.124081,
      2.346152,
      1,
      3.908655,
      NULL,
      1.410260,
      3.218682,
      0.330516,
      0,
      1,
      NULL,
      3,
      2,
      0,
      0.737650,
      0,
      2.423002,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.234076,
      2.042448,
      NULL,
      5.345860,
      1.944221,
      0,
      0,
      NULL,
      1,
      0,
      1.449246,
      3.638473,
      0,
      1.481850,
      1,
      NULL,
      0.227645,
      NULL,
      0.485993,
      0,
      0,
      1,
      1,
      NULL,
      0.161498,
      1,
      2.850620,
      NULL,
      3.561177,
      0.937822,
      1.946707,
      NULL,
      NULL,
      0.849191,
      3,
      6.454706,
      2.711312,
      8,
      0,
      3.281295,
      1.960701,
      1,
      0.550348,
      3,
      3,
      3,
      NULL,
      NULL,
      1.388730,
      3.758084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.885545,
      NULL,
      1,
      1,
      0,
      1.564630,
      0.732308,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.840719,
      NULL,
      2.165214,
      2.163066,
      1.015815,
      3,
      0.597008,
      1,
      1.512048,
      1.961422,
      0,
      NULL,
      0.441937,
      1,
      NULL,
      NULL,
      NULL,
      5.765086,
      0.851480,
      0.020379,
      1.274465,
      0,
      2,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0.413264,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.636443,
      NULL,
      1.256655,
      1,
      3,
      1,
      1,
      1.998306,
      0.817403,
      NULL,
      2,
      0,
      NULL,
      0.655481,
      1.405142,
      0,
      NULL,
      1.449208,
      1.408768,
      1.386165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.828348,
      '43220',
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


