set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8628956';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '213',
      '32044214',
      60.309320,
      9.878369,
      '1323132',
      15.248119,
      4,
      2.365188,
      3,
      '441001',
      4.379434,
      ' 4-17-1979',
      13,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.040073,
      0.838074,
      1,
      1,
      NULL,
      1,
      0.968123,
      0,
      1.007555,
      1,
      1,
      0.394610,
      0,
      0.406902,
      2,
      0,
      0.059536,
      1,
      1,
      1.163739,
      3.311050,
      1,
      1.805348,
      3.838143,
      0,
      1.153472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.042304,
      0.338073,
      3,
      0,
      0.962373,
      0.387045,
      0,
      1.272620,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.569196,
      0.835737,
      1,
      2.642439,
      0.885776,
      1.616176,
      3.051702,
      7.002064,
      1,
      1,
      NULL,
      0.009729,
      NULL,
      NULL,
      1.136844,
      NULL,
      NULL,
      1.071828,
      3,
      1,
      0,
      4,
      1,
      0,
      1,
      1,
      1.185404,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.159282,
      0.949631,
      1,
      1,
      NULL,
      1,
      5.677948,
      0.558553,
      5.935428,
      0,
      1,
      1.695917,
      1,
      NULL,
      NULL,
      1,
      0,
      1.805498,
      1.271919,
      1.831803,
      1,
      NULL,
      5,
      5.782479,
      0.138666,
      3.014804,
      1,
      5.314123,
      5,
      5.532554,
      1.163490,
      0.314186,
      5.625085,
      2.790976,
      NULL,
      0.901796,
      3.866486,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.076046,
      1,
      NULL,
      NULL,
      NULL,
      0.663030,
      0,
      1.855239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.567372,
      NULL,
      6.451427,
      3.239306,
      0.030470,
      0.659236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.429257,
      2.491210,
      1.178005,
      NULL,
      NULL,
      NULL,
      1.111779,
      1,
      1.418360,
      1,
      NULL,
      2,
      0.220001,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.822523,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.442826,
      1.616519,
      3.288284,
      0.760739,
      1,
      0,
      0.696409,
      NULL,
      0.804461,
      0,
      0,
      0.033449,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.828345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '24103',
      '',
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      3.644033,
      6.044117,
      3.843188,
      2,
      2,
      NULL,
      1,
      1,
      NULL);
commit;
end;
/


