set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8628956';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-7-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '242',
      '13002442',
      61.943064,
      80,
      NULL,
      37.581901,
      NULL,
      0.943165,
      1,
      '114241',
      0.031296,
      NULL,
      11.084210,
      48,
      1,
      NULL,
      NULL,
      3,
      0,
      0,
      0.337742,
      2,
      1.380216,
      1.691591,
      0,
      NULL,
      6,
      NULL,
      1.130317,
      1,
      2,
      0.901503,
      4,
      1,
      0,
      1.383944,
      2.288785,
      0.108234,
      0.410845,
      1,
      1.294160,
      0.439172,
      5,
      NULL,
      NULL,
      NULL,
      1.754273,
      NULL,
      NULL,
      7,
      2.416636,
      6.073606,
      2.330997,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.478656,
      1.478481,
      0.587170,
      3,
      NULL,
      0,
      0,
      3,
      0,
      0,
      NULL,
      NULL,
      7.865798,
      5.827844,
      1,
      1,
      2.241404,
      0.948523,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      5,
      NULL,
      0,
      NULL,
      0,
      0.579878,
      NULL,
      0,
      0.430022,
      0.178371,
      NULL,
      1.303325,
      0,
      0.817239,
      0.527033,
      NULL,
      1.485136,
      1,
      0.916960,
      0,
      0.885339,
      1,
      0,
      0.872280,
      0,
      NULL,
      NULL,
      1,
      1,
      1.433984,
      5.807719,
      1.763657,
      0,
      4.340391,
      0.224727,
      7.228934,
      3.880460,
      2.581833,
      6,
      NULL,
      NULL,
      4.282829,
      4.995129,
      0.107764,
      0.313004,
      0.588742,
      NULL,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.537096,
      1,
      0.827975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.676889,
      NULL,
      7,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.238963,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.510435,
      0.867936,
      0,
      NULL,
      1.060839,
      2,
      0.577732,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1.924894,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.047168,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.662954,
      0.872996,
      2.297721,
      1.504031,
      0.677206,
      0,
      NULL,
      0.477737,
      NULL,
      1.249746,
      1.709624,
      1.849140,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.033714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '23212',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '3244',
      NULL,
      NULL,
      1.405852,
      NULL,
      0,
      1,
      3.524620,
      NULL,
      1.441013,
      1.070314,
      0.689256);
commit;
end;
/


