set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8628956';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3104',
      '42022414',
      69.963667,
      70,
      '2432313',
      17,
      NULL,
      0,
      NULL,
      '203344',
      4.837313,
      '10-11-1989',
      21.061390,
      57,
      1,
      NULL,
      5.180394,
      3.961061,
      1.003357,
      0.839177,
      0,
      NULL,
      0,
      1,
      1,
      0.294145,
      3,
      1,
      1,
      5,
      NULL,
      1,
      4.129932,
      NULL,
      1,
      0,
      NULL,
      1,
      4.456661,
      1,
      0,
      1,
      1.485006,
      1,
      NULL,
      NULL,
      1.048367,
      NULL,
      NULL,
      6.450207,
      NULL,
      1,
      1.911922,
      0.039823,
      NULL,
      NULL,
      1.803632,
      3,
      2,
      1,
      1.894689,
      NULL,
      1,
      3,
      1,
      NULL,
      0.535236,
      1.132356,
      NULL,
      1,
      0.091180,
      4.115168,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.727220,
      3.472672,
      0.176396,
      0.982252,
      NULL,
      0.473770,
      1.487052,
      0,
      0,
      1.709171,
      0.629601,
      0.836590,
      0.578747,
      0.469064,
      0.187224,
      1,
      0.173648,
      1.295503,
      0,
      NULL,
      1,
      1.249658,
      NULL,
      NULL,
      1,
      1,
      4.200882,
      0,
      3,
      0.896942,
      NULL,
      NULL,
      1.881587,
      0,
      NULL,
      1,
      0,
      NULL,
      4.188630,
      0.748997,
      2.788584,
      4,
      4.830228,
      1,
      4,
      NULL,
      NULL,
      0.034946,
      1.849980,
      1,
      0.153646,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      1,
      1,
      1.538273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.111735,
      NULL,
      NULL,
      NULL,
      NULL,
      1.334192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.869094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.163208,
      NULL,
      1.729885,
      0,
      1,
      1.546345,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.127802,
      3,
      3,
      2.991871,
      0.581190,
      NULL,
      3.017594,
      1,
      3,
      1.936026,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      1,
      1.803054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '03011',
      '',
      '',
      0,
      '',
      NULL,
      '',
      3.709692,
      '4303',
      '',
      '',
      NULL,
      4,
      2.935875,
      NULL,
      1,
      NULL,
      NULL,
      2.697288,
      1);
commit;
end;
/


