set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8628956';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-1-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0213',
      '21114001',
      NULL,
      25.236051,
      '2420333',
      NULL,
      5,
      3.818283,
      0,
      '023040',
      2,
      ' 1-24-1995',
      22.195257,
      NULL,
      NULL,
      NULL,
      18.659128,
      NULL,
      0.196676,
      0,
      1.370599,
      2.831957,
      1,
      0.107277,
      0.697147,
      NULL,
      NULL,
      0,
      0,
      0.073366,
      0.991202,
      0.310231,
      5,
      1.403622,
      NULL,
      1.813978,
      1.172009,
      1,
      0.807759,
      NULL,
      NULL,
      3.501225,
      0.985504,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.138497,
      0.548220,
      0.556630,
      0.980842,
      1,
      2,
      1.742872,
      NULL,
      2.574037,
      0.721535,
      2.278918,
      1,
      0,
      NULL,
      2.100948,
      0.654468,
      1.568617,
      1.613822,
      NULL,
      2.425726,
      2.304573,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1.758148,
      NULL,
      NULL,
      0,
      NULL,
      1.557108,
      NULL,
      0,
      NULL,
      1.729031,
      0.765957,
      0.471183,
      1.558986,
      0.851508,
      NULL,
      0.786848,
      1.024640,
      0.950016,
      NULL,
      1,
      1.601711,
      1.293966,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1.944133,
      2,
      0.395470,
      5.971614,
      0.738431,
      0,
      3,
      0,
      1.431645,
      5.482168,
      NULL,
      1,
      1.074458,
      1,
      2,
      5,
      1.811399,
      NULL,
      2.204886,
      1,
      1,
      4.156399,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.250612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.288863,
      0,
      1,
      1,
      1.088359,
      1.057590,
      0.382641,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.268684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.967023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.846733,
      1.717686,
      0.258053,
      NULL,
      1.746548,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.909938,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.648841,
      1.724237,
      3,
      2.198003,
      0.932121,
      0.964143,
      1.919013,
      0.132282,
      0.889039,
      NULL,
      1.303236,
      NULL,
      NULL,
      0,
      0,
      0,
      1.755697,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.151540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.001596,
      '22403',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '4101',
      NULL,
      NULL,
      NULL,
      5.608752,
      2,
      0,
      2,
      0,
      1.300302,
      0.691255,
      NULL);
commit;
end;
/


