set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8628956';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      23,
      74,
      '0304340',
      52,
      4,
      1.936601,
      NULL,
      '312203',
      NULL,
      ' 6- 4-1989',
      31,
      36,
      0,
      NULL,
      5.071044,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1.512621,
      1,
      5.830307,
      0,
      1.231041,
      NULL,
      3,
      1,
      0.941810,
      0.804320,
      0.980130,
      NULL,
      1.579524,
      NULL,
      3.661400,
      0,
      1,
      1.653969,
      2.302244,
      0.788335,
      NULL,
      NULL,
      1.509542,
      NULL,
      NULL,
      5,
      0.606963,
      0,
      3.414086,
      NULL,
      1.334171,
      0,
      1.765957,
      0,
      1.580894,
      0,
      1.302225,
      3,
      1.065235,
      2.968315,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      3.493681,
      2.066856,
      0,
      2,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.987505,
      1.830160,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      0.651119,
      1.673354,
      0.391906,
      1,
      0.292337,
      1.990289,
      NULL,
      0,
      0.909525,
      NULL,
      NULL,
      NULL,
      1.225820,
      0,
      NULL,
      NULL,
      0,
      0.662179,
      0.076314,
      1,
      2,
      2.790187,
      4,
      1,
      1,
      1.301265,
      NULL,
      0,
      NULL,
      1,
      3,
      3.144615,
      0.563452,
      0,
      5,
      NULL,
      2,
      1,
      5.809915,
      2,
      1,
      NULL,
      NULL,
      8.518568,
      1.854502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.092071,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.770454,
      NULL,
      NULL,
      NULL,
      NULL,
      0.174555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.215366,
      1.238184,
      1.546115,
      0.032735,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.081553,
      1.364104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.418913,
      2.882733,
      0,
      1.121247,
      0.103526,
      NULL,
      1.225480,
      1,
      1,
      1,
      1,
      0,
      0,
      1.144784,
      0.407668,
      NULL,
      0,
      1,
      1.395064,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '10110',
      '',
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      '',
      '',
      NULL,
      NULL,
      1,
      1,
      0.764707,
      NULL,
      3.403827,
      3,
      3.668780,
      7);
commit;
end;
/


