set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8628956';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1230',
      '31313113',
      53,
      29.322000,
      '4342412',
      NULL,
      0,
      2,
      0,
      '034101',
      1.398751,
      ' 3-21-1981',
      20.440620,
      NULL,
      0,
      NULL,
      NULL,
      0.523735,
      NULL,
      1.192768,
      1.029517,
      0,
      0.821568,
      NULL,
      NULL,
      0.450780,
      0,
      1.651654,
      0,
      0,
      1.305740,
      1,
      NULL,
      1.113666,
      1,
      0.442896,
      0,
      1.326321,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.483159,
      1.190204,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.868273,
      1.261152,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.945408,
      0.478381,
      1.092589,
      1.567410,
      0,
      1.226349,
      0.582214,
      0.814920,
      NULL,
      0,
      1.405654,
      1,
      1.494536,
      1.823733,
      0,
      0.276167,
      1.031078,
      0.801559,
      NULL,
      1.323449,
      2,
      0.179896,
      NULL,
      NULL,
      1.790837,
      4,
      2.208700,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.042415,
      NULL,
      NULL,
      1.867885,
      1,
      NULL,
      5.894504,
      5,
      5.759168,
      2,
      6.782072,
      6,
      1,
      NULL,
      5.794997,
      0.785114,
      NULL,
      NULL,
      8,
      1.578099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      0.380900,
      0.658539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.659681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.784255,
      1,
      NULL,
      NULL,
      NULL,
      5.770697,
      0.717399,
      NULL,
      1.123038,
      0,
      0,
      0.766346,
      NULL,
      NULL,
      NULL,
      1.954191,
      0.369481,
      0.855526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.035480,
      0,
      1,
      1.933021,
      1.277323,
      0,
      1,
      0.482466,
      1,
      3,
      1,
      1,
      1.981809,
      1.146857,
      NULL,
      NULL,
      0.136185,
      0.582041,
      0,
      1.276683,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.297978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.870849,
      '40033',
      '',
      '',
      1,
      '',
      '',
      '',
      4.128723,
      '4032',
      '0020',
      '',
      0.948424,
      4,
      0,
      NULL,
      0,
      2,
      NULL,
      0.785475,
      0.944194);
commit;
end;
/


