set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8628956';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-7-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      46,
      '2301032',
      10.432248,
      4,
      0,
      1,
      '023111',
      NULL,
      ' 8-29-1993',
      100,
      53.258784,
      0,
      NULL,
      8.011722,
      0.343060,
      2,
      1,
      1.493843,
      3.173294,
      0.102061,
      1.050277,
      1.944151,
      1,
      1.735001,
      1.630160,
      0.905611,
      1.865817,
      1,
      1,
      NULL,
      NULL,
      0,
      2,
      0.902718,
      1.373455,
      NULL,
      0,
      0,
      3.572677,
      3,
      1.369232,
      NULL,
      NULL,
      1.011332,
      NULL,
      NULL,
      2.412810,
      NULL,
      1.876891,
      2.234740,
      1,
      1,
      0.591779,
      0,
      0.958196,
      NULL,
      1,
      1.677009,
      1.501700,
      0.817439,
      0,
      1,
      1,
      1.487487,
      1.514202,
      NULL,
      0.813939,
      NULL,
      3.437485,
      0,
      0,
      3.756427,
      1.854141,
      NULL,
      NULL,
      0.821059,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.717369,
      0.017150,
      NULL,
      0,
      1.891286,
      1.861886,
      NULL,
      0.683134,
      0.898050,
      NULL,
      1.804832,
      0,
      NULL,
      1.416265,
      NULL,
      1.618950,
      NULL,
      0.732242,
      5.815335,
      0,
      NULL,
      NULL,
      0,
      5.718631,
      1.105683,
      3.960686,
      0,
      1,
      1.602730,
      2,
      2,
      NULL,
      1,
      1.586007,
      6.095213,
      0,
      0.645781,
      2,
      4,
      NULL,
      NULL,
      NULL,
      4,
      4.363003,
      NULL,
      1.282931,
      NULL,
      NULL,
      NULL,
      1.938263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      0,
      1,
      2.404782,
      1.508078,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.946477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.867028,
      0.046382,
      1,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.014662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3,
      NULL,
      0.440261,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.734057,
      1.899828,
      NULL,
      0.539821,
      0,
      0.290532,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '03042',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      5,
      1.821506,
      1,
      NULL,
      3.611654,
      1.396982,
      2.396844,
      1.606728,
      NULL);
commit;
end;
/


