set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9430524';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-5-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '112',
      '42',
      26.066885,
      8,
      NULL,
      8,
      0,
      2.447279,
      1,
      NULL,
      0.946750,
      ' 9- 8-1980',
      37.753654,
      35.401236,
      0.399429,
      NULL,
      1.660712,
      NULL,
      1.769386,
      NULL,
      1.764493,
      1.754598,
      NULL,
      1,
      0.965406,
      0.873923,
      NULL,
      NULL,
      0,
      0,
      1.721745,
      0,
      NULL,
      0.094960,
      0.658801,
      1,
      1.468803,
      0.955474,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.820605,
      0.767011,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.716728,
      0,
      1.802254,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.128091,
      3.155809,
      0.121306,
      3,
      1,
      1.954842,
      0.135605,
      0,
      0.602990,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.515420,
      1.784157,
      0.171334,
      NULL,
      1,
      1,
      0.374390,
      1,
      5,
      NULL,
      0,
      1.167978,
      NULL,
      0,
      0.360033,
      1,
      0,
      0.766833,
      0,
      NULL,
      1.993732,
      1.591821,
      1.863219,
      0,
      1.188471,
      NULL,
      3,
      5.739226,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      1,
      1,
      1.277643,
      6,
      1.090146,
      0,
      1,
      4,
      0.403410,
      3,
      4,
      1.685151,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0,
      1.072973,
      2,
      3.031927,
      5.588623,
      7.311961,
      NULL,
      1.033046,
      0,
      1,
      1.046903,
      NULL,
      1.701167,
      0,
      0.652044,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.231680,
      NULL,
      0.343983,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3.378162,
      0,
      0,
      0.440099,
      0.520102,
      1,
      0.754588,
      1,
      NULL,
      0.029928,
      NULL,
      0.838086,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '44330',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      0.654993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


