set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9430524';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-9-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '340',
      '43',
      NULL,
      10.715397,
      '2213203',
      NULL,
      1,
      1.589885,
      0,
      '413313',
      5.469748,
      ' 3- 7-1994',
      6.651291,
      NULL,
      NULL,
      NULL,
      8.399620,
      0,
      0,
      0.673708,
      2,
      0.908461,
      1,
      0.042819,
      0.696339,
      0,
      1.743890,
      0,
      0.680471,
      6,
      0,
      1.148674,
      2,
      1.222897,
      0.548436,
      0,
      0.484125,
      0,
      5.933012,
      NULL,
      0.391674,
      2.084133,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.995313,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.953925,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      7,
      7.850721,
      0,
      5.092562,
      1,
      6,
      0.986853,
      1,
      1,
      1,
      0,
      0,
      3.664911,
      1,
      0,
      0.006324,
      0.030850,
      NULL,
      NULL,
      0.035628,
      1,
      1,
      NULL,
      1.306537,
      NULL,
      1,
      0.557455,
      NULL,
      0,
      NULL,
      7,
      0,
      NULL,
      1,
      1,
      NULL,
      4,
      0.808328,
      3,
      0.934143,
      1,
      0,
      NULL,
      0,
      2,
      NULL,
      1.795541,
      1,
      1.139939,
      0.996288,
      NULL,
      4.440517,
      NULL,
      0,
      0.684849,
      3,
      1,
      NULL,
      2,
      0,
      2,
      6,
      3.521978,
      1.259404,
      NULL,
      NULL,
      4.163370,
      NULL,
      3,
      1,
      2.181758,
      NULL,
      9,
      3,
      0,
      1.688291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.609476,
      1.187692,
      0.496149,
      NULL,
      4,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.007888,
      0.719801,
      NULL,
      2,
      1.563475,
      3.357238,
      0,
      1.277084,
      3,
      1.401349,
      1,
      0.122345,
      0.347402,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0.648145,
      NULL,
      0.155942,
      3.936539,
      0,
      0.483208,
      NULL,
      NULL,
      NULL,
      0.900068,
      NULL,
      1.301939,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.910157,
      0,
      0.289980,
      NULL,
      0,
      0,
      0.557550,
      NULL,
      2.385952,
      '24123',
      NULL,
      '',
      1.981837,
      NULL,
      '',
      '',
      1,
      '',
      '',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


