set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9430524';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      45,
      47.568584,
      '4223143',
      1,
      4,
      3.256343,
      1,
      '104244',
      5,
      NULL,
      56.944710,
      29,
      1.341440,
      NULL,
      NULL,
      1,
      1.097260,
      1,
      0,
      NULL,
      3,
      NULL,
      0,
      0,
      0,
      0.092525,
      NULL,
      7,
      1,
      7.320015,
      4,
      1.393194,
      1.079854,
      NULL,
      1.932567,
      0,
      5.093999,
      0,
      NULL,
      0.804289,
      NULL,
      2,
      2.060841,
      3.467017,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.468899,
      1,
      NULL,
      1.314715,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.558764,
      0,
      NULL,
      NULL,
      0,
      1.182704,
      1,
      1.682989,
      NULL,
      1.986817,
      3.538538,
      0,
      3,
      0,
      2,
      NULL,
      0,
      NULL,
      1,
      0.898481,
      NULL,
      0.227260,
      NULL,
      NULL,
      NULL,
      0.356007,
      1,
      5.174731,
      4,
      0,
      NULL,
      1,
      0,
      4.324693,
      1,
      7.278957,
      0,
      NULL,
      6,
      NULL,
      2.244758,
      NULL,
      1,
      0,
      1.050976,
      1,
      0,
      NULL,
      1,
      6,
      11.764905,
      4.076788,
      1.062530,
      NULL,
      0.399974,
      NULL,
      5,
      NULL,
      3.829474,
      1.442102,
      NULL,
      1.751450,
      NULL,
      1.574952,
      0,
      2,
      0.416225,
      2.538367,
      0,
      1,
      3.931243,
      0,
      1,
      5,
      1,
      5.637032,
      NULL,
      0.440553,
      NULL,
      0.268350,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.347115,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.788629,
      1,
      5.634413,
      3.863460,
      6.129402,
      1,
      3.900763,
      0,
      NULL,
      NULL,
      0.857785,
      5,
      0.345816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.245422,
      0,
      0,
      NULL,
      0,
      NULL,
      0.257000,
      2,
      NULL,
      0,
      1,
      0,
      0.479298,
      0.903687,
      0.788765,
      1.087069,
      1,
      1.726317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.457826,
      '34341',
      '',
      '',
      1.739432,
      '',
      '',
      NULL,
      0,
      '',
      NULL,
      NULL,
      0.294099,
      0,
      NULL,
      8.869439,
      1.053486,
      4,
      1.944000,
      5.628784,
      0);
commit;
end;
/


