set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9627735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-5-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '012',
      '33',
      42.756088,
      1.545923,
      NULL,
      31.032945,
      0,
      3,
      0,
      '421031',
      NULL,
      ' 7- 8-1996',
      40.137436,
      27,
      0.897359,
      NULL,
      0.939596,
      0,
      3.738642,
      0.489508,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.347181,
      1,
      1.676435,
      NULL,
      1.904975,
      0,
      NULL,
      0,
      0,
      0,
      0.129244,
      1.797541,
      1.326247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.024869,
      0,
      0.724877,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      1.335817,
      7,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.894706,
      NULL,
      NULL,
      1,
      1.896499,
      0,
      0,
      1.186815,
      NULL,
      NULL,
      NULL,
      NULL,
      0.361114,
      1.233521,
      1.118291,
      1.897812,
      NULL,
      1,
      0,
      0.321821,
      1,
      NULL,
      NULL,
      1.796599,
      5,
      1,
      1.478560,
      1.126642,
      1.887314,
      5,
      1.106467,
      3.005701,
      2,
      2.357214,
      NULL,
      1,
      NULL,
      2.824722,
      0.816467,
      6,
      4,
      11.863985,
      4,
      7,
      4,
      4,
      2.477637,
      8,
      0,
      0,
      0.305470,
      1.420196,
      NULL,
      1,
      0.822376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.510744,
      1.415064,
      NULL,
      0,
      1,
      1.148980,
      1.214748,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0.055003,
      3.004430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.197419,
      3.109149,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.855840,
      2.170411,
      NULL,
      2,
      2,
      0.834767,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.294724,
      0.026392,
      1,
      NULL,
      3,
      1.572768,
      0,
      0.517129,
      1,
      0,
      1.483850,
      1,
      1,
      1.928379,
      0,
      0.459831,
      0,
      0,
      0.129903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.755457,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.580278,
      '11430',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      NULL,
      NULL,
      1.748159,
      2.617056,
      1.040362,
      1,
      NULL,
      0.976582,
      NULL,
      NULL,
      3);
commit;
end;
/


