set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9627735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-1-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '402',
      '31301012',
      48,
      5,
      NULL,
      21,
      6,
      NULL,
      NULL,
      '323004',
      1,
      ' 7- 3-1979',
      NULL,
      9,
      1.988103,
      NULL,
      3.141146,
      0,
      3,
      1,
      0,
      NULL,
      NULL,
      2,
      1.860770,
      0.808121,
      NULL,
      NULL,
      1.024383,
      NULL,
      1,
      3.356554,
      0,
      NULL,
      NULL,
      0,
      1.592221,
      1.683276,
      0.063273,
      0,
      NULL,
      1.712928,
      0.001151,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.533871,
      0,
      0.806676,
      0.957901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.311601,
      NULL,
      9,
      1,
      0,
      0,
      0.281541,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.039663,
      0,
      1,
      0,
      0.174726,
      0.115281,
      0.613993,
      0.227844,
      1.209439,
      NULL,
      1,
      0.652833,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1.391714,
      3.196269,
      2,
      NULL,
      2,
      1,
      2.460437,
      0.835333,
      0,
      2.165587,
      0.677598,
      1.819823,
      6,
      9.751155,
      6,
      NULL,
      4.332314,
      6,
      7.785989,
      7,
      2.360820,
      0.315477,
      1.199833,
      NULL,
      3,
      1,
      0.757197,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.493144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.137103,
      1.118697,
      0,
      NULL,
      NULL,
      NULL,
      0.554331,
      NULL,
      NULL,
      NULL,
      0.439271,
      0,
      0.489522,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.702035,
      NULL,
      0.478824,
      0.175857,
      3.027349,
      2,
      1.890959,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0.715197,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.116623,
      '43211',
      NULL,
      '',
      0.157580,
      '',
      '',
      NULL,
      1.100441,
      NULL,
      '',
      '',
      0,
      0.247096,
      NULL,
      1.092646,
      NULL,
      NULL,
      3,
      0.387807,
      2);
commit;
end;
/


