set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9627735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '300',
      NULL,
      21,
      NULL,
      '1414213',
      NULL,
      NULL,
      NULL,
      3,
      '420202',
      0,
      NULL,
      249,
      126,
      NULL,
      NULL,
      2,
      1.201754,
      3.016649,
      0,
      NULL,
      1,
      1.879886,
      1,
      2,
      0.483917,
      0,
      NULL,
      1,
      0.721282,
      1.805438,
      4.588803,
      0.515500,
      0,
      0,
      NULL,
      1.283312,
      1,
      2,
      1,
      3,
      0.157274,
      NULL,
      0.054415,
      NULL,
      NULL,
      1.778292,
      NULL,
      NULL,
      1,
      0.371216,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      9,
      1,
      0,
      NULL,
      0.247069,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.929563,
      0.568472,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.912582,
      0,
      NULL,
      NULL,
      5,
      1,
      0.748124,
      1.823861,
      0.827526,
      0.291122,
      NULL,
      1.275928,
      2.369831,
      0.242553,
      1.790856,
      1.891901,
      4,
      4,
      1,
      2.548081,
      NULL,
      3,
      NULL,
      0,
      3,
      NULL,
      1.041095,
      2,
      NULL,
      2,
      2.130671,
      0,
      NULL,
      6,
      8.440631,
      1.913235,
      0.540858,
      0,
      0,
      2,
      NULL,
      0.842748,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.435980,
      0,
      0,
      0.257167,
      1,
      0.796945,
      0.811931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.813257,
      NULL,
      NULL,
      NULL,
      NULL,
      0.866563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.337760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.805987,
      0.769689,
      1.998554,
      0.346940,
      4,
      0,
      1.035355,
      NULL,
      NULL,
      NULL,
      1.851413,
      4,
      1.523831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.986620,
      1.571831,
      0.384432,
      2.461057,
      2.171104,
      0,
      2,
      1.467754,
      3,
      1.499841,
      0,
      NULL,
      1.750452,
      NULL,
      1,
      0.149894,
      1,
      0.319030,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.712228,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.413018,
      '01034',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      1.308686,
      '',
      '',
      '',
      4.909680,
      3,
      3.246794,
      2.642793,
      2.987243,
      1.618678,
      2.747065,
      NULL,
      2.862537);
commit;
end;
/


